//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 15: Heat Exchange Equipment
//Example  : 15.6 Pg 463
//Title: Extended surface equipment. 
//================================================================================================

model Ex15_6

extends Modelica.Constants;

//===================
// Parameter Section
parameter Real k(unit="Btu/lb.F")=0.0162      "Thermal conductivity , from App.12 ";
parameter Real Cp(unit="Btu/lb.F")=0.25       "Specific heat, from App.14";
parameter Real Di(unit="ft")=0.2557           "Inner Diameter of shell, App.3";
parameter Real Di1(unit="ft")=0.1342          "Inner Diameter of tube, App.3";
parameter Real Do(unit="ft")=0.1583           "Outer Diameter of pipe, App.3";
parameter Real muw(unit="lb/ft.h")=0.0528     "Viscosity at 250 F";
parameter Real mu(unit="lb/ft.h")=0.046       "Viscosity ";
parameter Real hi(unit="Btu/ft^2.h.F")=1500   "Inside Film coefficient";
parameter Real G(unit="lb/h.ft^2")=5000       "Mass velocity";
parameter Real jH(unit="nil")=0.0031          "Heat transfer factor, taken from Fig15.13 Pg462";
parameter Real etaf(unit="nil")=0.93          "Fin efficiency";

//===================
// Variable Section

Real A(unit="ft^2")                  "Cross sectional area";
Real P(unit="ft")                    "Perimeter of air space";
Real De(unit="ft")                   "Equivalent Diameter of tubes";
Real Re(unit="nil")                  "Reynolds number";
Real Pr(unit="nil")                  "Prandtl number";
Real ho(unit="Btu/ft^2.h.F")         "Film coefficient";
Real rH(unit="ft")                   "Hydraulic radius";
Real x(unit="nil")                   "Variale to represent (mu/muw)";
Real y(unit="nil")                   "Variable to represent aF*xF";
Real DL(unit="ft")                   "Logarithmic Diameter";
Real Ai(unit="ft^2")                 "Inside area";
Real AF(unit="ft^2")                 "Fin area";
Real xw(unit="ft")                   "Wall thickness";
Real Ui(unit="Btu/h.ft^2.F")         "Overall heat transfer coefficient";

//==================
//Equation  Section 
equation
A= (pi*((Di^2)-(Do^2))/4)-((28*0.5*0.035)/144); //28 is number of longitudianl fins.
P= (pi*Di)+2.83; //2.83 is TSA of pipe and fins
rH= A/P;
De= 4*rH;
Re=(De*G)/mu; //Its given 3.37*10^3 in T.B Here we get 3382.63
x=(mu/muw)^(0.14);
Pr= (Cp*mu)/k;
ho= (jH*Cp*G*x)/Pr^(2/3);
y= (0.5/12)*sqrt((2*ho)/(26*(0.035/12)));
DL= (Do-Di1)/log(Do/Di1);
Ai= (pi*Di1*1);
AF=(2.83-0.416); //AF+Ab=2.83.
xw=(1.9-1.61)/(2*12);
Ui= 1/((Ai/(ho*((etaf*AF)+0.416)))+((xw*Di1)/(26*DL))+(1/hi));

end Ex15_6;
