//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 16: Evaporation
//Example  : 16.1 Pg 497
//Title: Performance of tubular evaporators. 
//================================================================================================

// This problem is solved with many approximations in textbook. So it is done accordingly in code.

package Ex16_1
model Ex16_1_1
extends Modelica.Constants;
//===================
// Parameter Section

// A table containing the values of mu,rho,k and lamda for raw milk and 25%solids is given.Pg 497

parameter Real F(unit="Kg/s")=1.11*10^(-2)"Feed rate per tube";
parameter Real d(unit="m")=0.032          "Diameter of tubes";
parameter Real l(unit="m")=6              "Length of tubes";
parameter Real T1(unit="C")=60            "Temperature at which evaporation takes place";
parameter Real T2(unit="C")=70            "Temperature of steam";
parameter Real U(unit="W/m^2.K")=2000     "Guessed value of overall heat transfer coefficient";
parameter Real U1(unit="W/m^2.K")=1900    
"Guessed value of overall heat transfer coefficient at bottom";

parameter Real k(unit="W/m.K")=0.662      "Thermal conductivity of steam at 70 C ";
parameter Real Cp(unit="J/Kg.K")=4184     "Specific heat";
parameter Real mu(unit="cP")=0.406        "Viscosity at 70 C";
parameter Real lamda(unit="J/g")=2331     "Latent heat of steam at 70 C";

//===================
// Variable Section
Real deltaT(unit="nil")              "Temperature difference";
Real m(unit="g/s")                   "Mass flow rate";
Real tou(unit="Kg/s.m")              "Liquid loading on tube";
Real Re(unit="nil")                  "Reynolds number";
Real Pr(unit="nil")                  "Prandtl number";
Real ho(unit="W/m^2.K")              "Steam condensate film coefficient";
Real hw(unit="W/m^2.K")              "Wall coefficient";
Real hi(unit="W/m^2.K")              "Milk film coefficient at the top";
Real Re1(unit="nil")                 "Reynolds number w.r.t milk at the top";
Real tou1(unit="Kg/s.m")             "Liquid loading on top of tube";
Real U2(unit="W/m^2.K")              "Overall heat transfer coefficient";
Real r(unit="g/s")                   "Rate of evaporation";
Real Re2(unit="nil")                 "Reynolds number w.r.t milk at the bottom";
Real tou2(unit="Kg/s.m")             "Liquid loading at the bottom of tube";
Real hi1(unit="W/m^2.K")             "Milk film coefficient at the bottom";
Real hiavg(unit="W/m^2.K")           "Average milk film coefficient";
Real U3(unit="W/m^2.K")              "Overall heat transfer coefficient";


//==================
//Equation  Section 
equation
deltaT=T2-T1;
m= U*pi*d*l*deltaT/lamda;
tou= (m*10^(-3))/(pi*0.032);
Re= (4*tou)/(4.06*10^(-4));
Pr= Cp*(4.06*10^(-4))/k;
ho= 0.27*k*(((978/(4.06*10^(-4)))^2)*9.8)^(1/3);
//InT.B its given 6.87*10^3.Here we get 6873.41.
 //0.27 is Nusselt numer obtained from Fig 13.2 Pg394. 978 is density of water at 70 C.
hw=(16.3/(2*10^(-3))); 
//InT.B its given 8.15*10^3.Here we get 8150.
//If wall thickness is 2mm and km=16.3 W/m.K. Then hw is mentioned above.
Re1= (4*0.11)/(0.94*10^(-3)); //viscosity of milk =0.94cP which is given in table, Pg 497. 
tou1= F/(pi*0.032);
hi= 0.28*0.62*(((1010/(9.4*10^(-4)))^2)*9.8)^(1/3);
//InT.B its given 3.90*10^3.Here we get 3897.21.
//0.28 is Nu , obtained from fig 13.2 Pg394. 0.62 and 1010 given in table.Pg497
(1/U2)=(1/hi)+(1/hw)*(3.2/3.4)+(1/ho)*(3.2/3.6);
//In T.B its 1.99*10^3. Here it is 1994.42.
r=(U1*10*pi*d*l)/2357; //2357 is lamda given in table. Pg497.
tou2= 6.2*10^(-3)/(pi*d); 
//Product flow rate:11.1-4.9=6.2 g/s.
Re2=(4*tou2)/(1.6*10^(-3)); //1.6*10^-3 is mu given in table  Pg 497.
hi1= 0.33*0.55*(((1030/(1.6*10^(-3)))^2)*9.8)^(1/3);
//InT.B its given 2.90*10^3.Here we get 2895.77.
//0.55 and 1030 given in table Pg497 and 0.33 is Nu obtained from Fig 13.2 Pg394.
hiavg= (hi+hi1)/2; //Here we get 3396.49. In T.B its 3400.
(1/U3)=(1/hiavg)+(1/8660)+(1/7730);
//InT.B its given 1.86*10^3.Here we get 1854.39.

end Ex16_1_1;

model Ex16_1_2
extends Modelica.Constants;
//===================
// Parameter Section

// A table containing the values of mu,rho,k and lamda for raw milk and 25%solids is given.Pg 497

parameter Real F(unit="Kg/s")=1.11*10^(-2)"Feed rate per tube";
parameter Real d(unit="m")=0.032          "Diameter of tubes";
parameter Real l(unit="m")=6              "Length of tubes";
parameter Real T1(unit="C")=60            "Temperature at which evaporation takes place";
parameter Real T2(unit="C")=70            "Temperature of steam";
parameter Real U(unit="W/m^2.K")=2000     "Guessed value of overall heat transfer coefficient";
parameter Real U1(unit="W/m^2.K")=1900    
"Guessed value of overall heat transfer coefficient at bottom";

parameter Real k(unit="W/m.K")=0.662      "Thermal conductivity of steam at 70 C ";
parameter Real Cp(unit="J/Kg.K")=4184     "Specific heat";
parameter Real mu(unit="cP")=0.406        "Viscosity at 70 C";
parameter Real lamda(unit="J/g")=2331     "Latent heat of steam at 70 C";

//===================
// Variable Section
Real r1(unit="g/s")                  "Corrected rate of evaporation";

//==================
//Equation  Section 
equation
r1=4.86*(1860/1900); //These values are obtained in 16_1_1;

end Ex16_1_2;

model Ex16_1_3
extends Modelica.Constants;
//===================
// Parameter Section

// A table containing the values of mu,rho,k and lamda for raw milk and 25%solids is given.Pg 497

parameter Real F(unit="Kg/s")=1.11*10^(-2)"Feed rate per tube";
parameter Real d(unit="m")=0.032          "Diameter of tubes";
parameter Real l(unit="m")=6              "Length of tubes";
parameter Real T1(unit="C")=60            "Temperature at which evaporation takes place";
parameter Real T2(unit="C")=70            "Temperature of steam";
parameter Real U(unit="W/m^2.K")=2000     "Guessed value of overall heat transfer coefficient";
parameter Real U1(unit="W/m^2.K")=1900    
"Guessed value of overall heat transfer coefficient at bottom";

parameter Real k(unit="W/m.K")=0.662      "Thermal conductivity of steam at 70 C ";
parameter Real Cp(unit="J/Kg.K")=4184     "Specific heat";
parameter Real mu(unit="cP")=0.406        "Viscosity at 70 C";
parameter Real lamda(unit="J/g")=2331     "Latent heat of steam at 70 C";

//===================
// Variable Section
Real x(unit="nil")                   "Solids content";

//==================
//Equation  Section 
equation
13.5*(11.1/(11.1-4.76))=x; //These values are obtained in previous subdivisions.

end Ex16_1_3;

model Ex16_1_4
extends Modelica.Constants;
//===================
// Parameter Section

// A table containing the values of mu,rho,k and lamda for raw milk and 25%solids is given.Pg 497

parameter Real F(unit="Kg/s")=1.11*10^(-2)"Feed rate per tube";
parameter Real d(unit="m")=0.032          "Diameter of tubes";
parameter Real l(unit="m")=6              "Length of tubes";
parameter Real T1(unit="C")=60            "Temperature at which evaporation takes place";
parameter Real T2(unit="C")=70            "Temperature of steam";
parameter Real U(unit="W/m^2.K")=2000     "Guessed value of overall heat transfer coefficient";
parameter Real U1(unit="W/m^2.K")=1900    
"Guessed value of overall heat transfer coefficient at bottom";

parameter Real k(unit="W/m.K")=0.662      "Thermal conductivity of steam at 70 C ";
parameter Real Cp(unit="J/Kg.K")=4184     "Specific heat";
parameter Real mu(unit="cP")=0.406        "Viscosity at 70 C";
parameter Real lamda(unit="J/g")=2331     "Latent heat of steam at 70 C";

//===================
// Variable Section
Real delta(unit="m")                 "Film thickness at top";
Real delta1(unit="m")                "Film thickness at bottom";
Real u(unit="m/s")                   "Film velocity at top";
Real u1(unit="m/s")                  "Film velocity at bottom";
Real uavg(unit="m/s")                 "Average velocity";
Real tavg(unit="s")                   "Average residence time";

//==================
//Equation  Section 
equation
delta=((3*(9.4*10^(-4))*0.11)/((1010^2)*9.8))^(1/3);
delta1=((3*(1.6*10^(-3))*0.0617)/((1030^2)*9.8))^(1/3);
u=(0.11/1010)/delta;
u1=(0.0617/1030)/delta1; // The value deviates 7% from the textbook value due to the decimal digits.
uavg=(u+u1)/2;
tavg=(l/uavg); // The value deviates by 4% due to decimal digits in previous  value (u1).

end Ex16_1_4;

end Ex16_1;
