//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 16: Evaporation
//Example  : 16.2 Pg 504
//Title: Performance of tubular evaporators. 
//================================================================================================

model Ex16_2
//===================
// Parameter Section

// The enthalpy values for appropriate conditions are taken from Fig16.6 Pg 503.
//The enthalpy values for vapour leaving is found out from steam tables.

parameter Real F(unit="lb/h")=20000             "Feed rate";
parameter Real U(unit="Btu/h.ft^2.F")=250       "Overall heat transfer coefficient";
parameter Real T(unit="F")=100                  "Feed temperature";
parameter Real T1(unit="F")=124                 "B.P of water at 100mmHg , from App. 7 Pg1094";
parameter Real T2(unit="F")=197                 "B.P of solution, From Fig 16.3 Pg 494.";
parameter Real X(unit="lb")=4                   "Amount of water in feed"; 
//X is used to represent it.
parameter Real Y(unit="lb")=1                   "Amount of water in thick liquor";
//Y is used to represent it.

//===================
// Variable Section
Real Z(unit="lb")          "Water evaporated"; //Z is used to represent it.
Real m(unit="lb/h")        "Flow rate of thick liquor";
Real m1(unit="lb/h")       "Quantity of water evaporated for total feed";
Real BPE(unit="F")         "Boiling point elevation";
Real q(unit="Btu/h")       "Rate of heat transfer";
Real ms(unit="lb/h")       "Mass flow rate of steam";
Real A(unit="ft^2")        "Heating area";
Real e(unit="nil")         "Steam economy";

//==================
//Equation  Section 
equation
Z=X-Y;
m1=Z*F*0.20;  //0.20 is initial concentration.
m=F-m1;
BPE=T2-T1;
q=(F-m)*1149+ (m*221)-(F*55);
//In T.B its given 14456000.Here its 1.4456*10^7.
// 1149 is Enthalypy of vapor taken from App.7 & and App.14 Pg1094 and Pg1106 respectively. 
//55 is Enthalpy of  feed for 20% solids taken from Fig 16.6 Pg503.
// 221 is Enthalpy of Thick liquor taken from Fig 16.6 Pg503.

ms= q/939;
//Here we get 15395.1 , In T.B its 15400.
//939 is Heat of vapourisation of steam from App.7 Pg 1094.

e= m1/ms;
A= q/(U*(259-197)); 

// The values of q, e, A have been obtained with small deviations due to decimal digits.

end Ex16_2;
