//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 16: Evaporation
//Example  : 16.3 Pg 507
//Title: Performance of tubular evaporators. 
//================================================================================================

model Ex16_3
//===================
// Parameter Section
parameter Real T(unit="C")=108            "Temperature of steam in 1st effect";
parameter Real T1(unit="C")=52            "B.P pf solution in last effect";
parameter Real U1(unit="W/m^2.C")=2500    "Overall heat transfer coefficient in 1st effect";
parameter Real U2(unit="W/m^2.C")=2000    "Overall heat transfer coefficient in 2nd effect";
parameter Real U3(unit="W/m^2.C")=1500    "Overall heat transfer coefficient in 3rd effect";

//===================
// Variable Section
Real deltaT1(unit="C")          "Temperature drop in 1st effect";
Real deltaT2(unit="C")          "Temperature drop in 2nd effect";
Real deltaT3(unit="C")          "Temperature drop in 3rd effect";
Real deltaT(unit="C")           "Total temperature drop";
Real BP1(unit="C")              "Boiling point in 1st effect";
Real BP2(unit="C")              "Boiling point in 2nd effect";

//==================
//Equation  Section 
equation
deltaT=T-T1;
deltaT1= ((1/U1)/((1/U1)+(1/U2)+(1/U3)))*deltaT;
deltaT2= ((1/U2)/((1/U1)+(1/U2)+(1/U3)))*deltaT;
deltaT3= ((1/U3)/((1/U1)+(1/U2)+(1/U3)))*deltaT;
BP1=T-deltaT1;
BP2=BP1-deltaT2;

end Ex16_3;
