//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 17: Principles of diffusion and mass transfer between phases
//Example  : 17.4 Pg 541
//Title: Transient diffusion. 
//================================================================================================

model Ex17_4
//===================
// Parameter Section
parameter Real d(unit="cm")=1.5                     "Diameter";
parameter Real Dv(unit="cm^2/s")=4.2*10^(-6)        "Diffusion coefficient in solution";
parameter Real Dv1(unit="cm^2/s")=6*10^(-7)         "Diffusion coefficient in polymer phase";

//===================
// Variable Section
Real kc(unit="nil")       "External coefficient";
Real Bim(unit="nil")      "Biot number";
Real t1(unit="h")         "Time taken ";
Real t2(unit="h")         "Time taken ";

//==================
//Equation  Section 
equation
kc=Dv1/0.02;
Bim= (1.9*kc*0.12)/Dv; //m=1.9 and s=0.12.

//For Y=0.5 and Bim=1.63 Fo=0.7.
t1= (0.7*0.24^2)/(Dv*3600);
//For Y=0.1, interpolation gives Fo=0.24.
t2=(2.4*0.24^2)/(Dv*3600);

end Ex17_4;
