//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 18: Gas Absorption.
//Example  : 18.1 Pg 573
//Title: Packings and packed tower design. 
//================================================================================================

package Ex18_1
model Ex18_1_1
extends Modelica.Constants;

// The answers are changed slightly due to decimal digits.

//===================
// Parameter Section
parameter Real F(unit="ft^3")=25000       "Gas quantity";
parameter Real x(unit="nil")=1.25         "Varaible to represent ratio of liquid flow to gas flow";
parameter Real T(unit="F")=68             "Temperature";
parameter Real P(unit="atm")=1            "Pressure";
parameter Real deltaP(unit="atm")=0.5     "Pressure difference";
parameter Real rhox(unit="lb/ft^3")=62.3  "Density";
parameter Real FP(unit="nil")=92          "Packing factor, taken from Table18.1 Pg568"; 
parameter Real nu(unit="cSt")=1           "Kinematic viscosity";            

//===================
// Variable Section
Real rhoy(unit="lb/ft^3")            "Density";
Real mavg(unit="lb/lbmol")           "Average molecular weight";
Real y(unit="nil")                   "Variale to represent pressure drop correlation";
Real Gx(unit="lb/ft^2.h")            "Mass velocity of liquid stream";
Real Gy(unit="lb/ft^2.h")            "Mass velocity of gas stream";
Real Cs(unit="nil")                  "Capacity factor";
Real uo(unit="ft/s")                 "Superficial gas velocity";
Real z(unit="lb/h")                  "Variale to represent total gas flow";
Real S(unit="ft^2")                  "Cross sectional area";
Real D(unit="ft")                    "Diameter"; 

//==================
//Equation  Section 
equation
mavg=(29*0.98)+(17*0.02);
rhoy=(mavg/359)*(492/(460+68));
y=1.25*(rhoy/rhox)^0.5;
Cs= 1.38/(FP^0.5*nu^0.05);
uo=Cs*((rhox-rhoy)/rhoy)^0.5;
Gy=uo*rhoy*3600;
Gx=1.25*Gy;
z=F*rhoy;
S=z/1000;
D=((4*S)/pi)^0.5;


end Ex18_1_1;

model Ex18_1_2
extends Modelica.Constants;

// The answers are changed slightly due to decimal digits.

//===================
// Parameter Section
parameter Real F(unit="ft^3")=25000       "Gas quantity";
parameter Real x(unit="nil")=1.25         "Varaible to represent ratio of liquid flow to gas flow";
parameter Real T(unit="F")=68             "Temperature";
parameter Real P(unit="atm")=1            "Pressure";
parameter Real deltaP(unit="atm")=0.5     "Pressure difference";
parameter Real rhox(unit="lb/ft^3")=62.3  "Density";
parameter Real FP(unit="nil")=92          "Packing factor, taken from Table18.1 Pg568"; 
parameter Real nu(unit="cSt")=1           "Kinematic viscosity";            

//===================
// Variable Section
Real x1(unit="nil")                 
 "Variable to represent ratio of design velocity to that of flooding velocity";
Real y1(unit="nil")   
 "Variable to represent ratio of design velocity to that of flooding velocity";
 
 //==================
//Equation  Section 
equation
x1=1.38/1.95; //Gydesign=1.38, Gyflooding=1.95
y1=1000/1650; //Gydesign=1000, Gyflooding=1650. From Fig18.5 Pg571

end Ex18_1_2;

end Ex18_1;
