//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education, 2014

//Chapter 2: Fluid Statics and its Applications
//Example  : 2.2 Pg 38
//Title: Application of flud statics.
//================================================================================================

package Ex2_2
model Ex2_2_1
  
  //===================
  // Parameter Section
  parameter Real q(unit = "bbl/day") = 1500 "Flowrate ";
  parameter Real mu(unit = "cP") = 1.1 "Viscosity of petroleum";
  parameter Real rho1(unit = "Kg/m^3") = 865 "Density of oil";
  parameter Real rho2(unit = "Kg/m^3") = 1153 "Density of acid";
  
  //===================
  // Variable Section
  Real V(unit = "gal") "Volume of the vessel";
  Real t(unit = "h") "Separation time";
  
  //==================
  // Equation  Section
equation
  t = 100 * 1.1 / (rho2 - rho1);
  V = 2 * 43.8 * 23;
//43.8 is obtained by converting the flowrate to gal/min.
//The fraction of tank volume occupied by the liquid is 95% and for horizontal cylinder, the liquid depth is 90%of the tank diameter.
  
end Ex2_2_1;

model Ex2_2_2
  
  //===================
  // Parameter Section
  parameter Real q(unit = "bbl/day") = 1500 "Flowrate ";
  parameter Real mu(unit = "cP") = 1.1 "Viscosity of petroleum";
  parameter Real rho1(unit = "Kg/m^3") = 865 "Density of oil";
  parameter Real rho2(unit = "Kg/m^3") = 1153 "Density of acid";
  //===================
  // Variable Section
  
  Real ZT(unit = "ft") "Height of the acid overflow ";
  Real ZA2(unit = "ft") "Height of the heavy liquid overflow ";
  //==================
  // Equation  Section
equation
  
  ZT = 0.9 * 4;
  ZA2 = 1.8 + (3.6 - 1.8) * (54 / 72);
end Ex2_2_2;



end Ex2_2;
