//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 21: Distillation.
//Example  : 21.1 Pg 665
//Title: Flash distillation. 
//================================================================================================

package Ex21_1
model Ex21_1_1
//===================
// Parameter Section
parameter Real Tf(unit="C")=92                    "Boiling point of feed";
parameter Real T(unit="C")=95                     "Temperature in the separator";
parameter Real alpha(unit="nil")=2.45             "Relative volatility"; 
parameter Real xf(unit="nil")=0.5                 "Composition of a component";
parameter Real f(unit="nil")=0.4                  "Molar fraction of feed that is vapourized";
parameter Real lamda1(unit="cal/g.mol")=7360      "latent heat of vapourisation of benzene";
parameter Real lamda2(unit="cal/g.mol")=7960      "latent heat of vapourisation of toluene";
parameter Real Cp1(unit="cal/mol.C")=33           "Specific heat of benzene";
parameter Real Cp2(unit="cal/mol.C")=40           "Specific heat of toluene";

//===================
// Variable Section
Real x(unit="nil")               "Mole fraction";
Real y(unit="nil")               "Mole fraction";


//==================
//Equation  Section 
equation
xf=(f*((alpha*x)/(1+(1.45*x))))+(0.6*x);
y=(alpha*x)/(1+(1.45*x));


end Ex21_1_1;

model Ex21_1_2
//===================
// Parameter Section
parameter Real Tf(unit="C")=92                    "Boiling point of feed";
parameter Real T(unit="C")=95                     "Temperature in the separator";
parameter Real alpha(unit="nil")=2.45             "Relative volatility"; 
parameter Real xf(unit="nil")=0.5                 "Composition of a component";
parameter Real f(unit="nil")=0.4                  "Molar fraction of feed that is vapourized";
parameter Real lamda1(unit="cal/g.mol")=7360      "latent heat of vapourisation of benzene";
parameter Real lamda2(unit="cal/g.mol")=7960      "latent heat of vapourisation of toluene";
parameter Real Cp1(unit="cal/mol.C")=33           "Specific heat of benzene";
parameter Real Cp2(unit="cal/mol.C")=40           "Specific heat of toluene";

//===================
// Variable Section
Real x(unit="nil")               "Mole fraction";
Real y(unit="nil")               "Mole fraction";
Real Cpavg(unit="cal/mol.C")     "Average specific heat";
Real lamdaavg(unit="cal/gmol")   "Average latent heat";
Real TF(unit="C")                "Temperature of feed";


//==================
//Equation  Section 
equation
xf=(f*((alpha*x)/(1+(1.45*x))))+(0.6*x);
y=(alpha*x)/(1+(1.45*x));
Cpavg=(0.5*Cp1)+(0.5*Cp2);
lamdaavg=(y*lamda1)+(0.368*lamda2);
(TF-95)*Cpavg=0.4*lamdaavg;

end Ex21_1_2;

end Ex21_1;
