//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 21: Distillation.
//Example  : 21.6 Pg 709
//Title: Design of sieve plate columns. 
//================================================================================================

package Ex21_6
model Ex21_6_1
extends Modelica.Constants;

//From Perry's handbook Pg3-188 density values are taken and from Pg 1-26 chord length vlaue is taken.
//From Langes handbook Pg1650, surface tension values are taken.
 
//===================
// Parameter Section
parameter Real T(unit="C")=65                    "Normal boiling point";
parameter Real M(unit="Kg/Kmol")=32              "Molecular weight"; 
parameter Real Kv(unit="nil")=0.29               "Coefficient";
parameter Real C0(unit="nil")=0.73               "Discharge coefficient";

//===================
// Variable Section
Real x(unit="nil")               "Variable to represent (L/V)*(rhov/rhoL)^0.5";
Real rhov(unit="Kg/m^3")         "Vapour density";
Real uc(unit="m/s")              "Vapour velocity";
Real V(unit="m^3/s")             "Vapour flow rate";
Real A(unit="m^2")               "Cross sectional area";
Real Ac(unit="m^2")              "column area";
Real Dc(unit="m")                "Diameter of column";

//==================
//Equation  Section 
equation
rhov= (M*273)/(22.4*338);
x=(3.5/4.5)*(1.15/750)^0.5;
uc= (Kv*((750-1.15)/1.15)^0.5*(19/20)^0.2)*0.3048; //0.3048 is used for conversion from ft to m.
V=(5800*4.5)/(3600*1.15);
A= V/uc;
Ac=A/0.7;
Dc=sqrt((4*Ac)/pi);

end Ex21_6_1;

model Ex21_6_2
extends Modelica.Constants;

//From Perry's handbook Pg3-188 density values are taken and from Pg 1-26 chord length vlaue is taken.
//From Langes handbook Pg1650, surface tension values are taken.
 
//===================
// Parameter Section
parameter Real T(unit="C")=65                    "Normal boiling point";
parameter Real M(unit="Kg/Kmol")=32              "Molecular weight"; 
parameter Real Kv(unit="nil")=0.29               "Coefficient";
parameter Real C0(unit="nil")=0.73               "Discharge coefficient";

//===================
// Variable Section
Real u0(unit="m/s")              "Vapour velocity through holes";
Real hd(unit="mm")               "Height of dry plate";
Real hw(unit="mm")               "Height of weir plate";
Real Lw(unit="m")                "Lenght of weir plate";
Real qL(unit="m^3/min")          "Liquid flow rate";
Real how(unit="mm")              "Height of clear liquid"; 
Real hl(unit="mm")               "Equivalent head of liquid";
Real ht(unit="mm")               "total drop per plate";

//==================
//Equation  Section 
equation
u0=2.23/0.1008;
hd=((u0)^2*1.15*51)/(750*(C0)^2);
hw=2*25.4;
Lw=1.62*2.27/2;
qL=(5800*3.5)/(760*60);
how=43.4*(0.45/1.84)^(2/3);
hl= 0.6*(hw+how); //beta=0.6.
ht=hd+hl;

end Ex21_6_2;

model Ex21_6_3
extends Modelica.Constants;

//From Perry's handbook Pg3-188 density values are taken and from Pg 1-26 chord length vlaue is taken.
//From Langes handbook Pg1650, surface tension values are taken.
 
//===================
// Parameter Section
parameter Real T(unit="C")=65                    "Normal boiling point";
parameter Real M(unit="Kg/Kmol")=32              "Molecular weight"; 
parameter Real Kv(unit="nil")=0.29               "Coefficient";
parameter Real C0(unit="nil")=0.73               "Discharge coefficient";

//===================
// Variable Section
Real Z(unit="mm")                "Height of liquid in downcomer";
Real Zc(unit="mm")               "Height of clear liquid";

//==================
//Equation  Section 
equation
Zc=(2*40.7)+71.7+10;
Z=Zc/0.5;

end Ex21_6_3;

end Ex21_6;
