//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 21: Distillation.
//Example  : 21.8 Pg 719
//Title: Plate efficiencies. 
//================================================================================================

model Ex21_8

//All parameters are taken from Example 21.6

//===================
// Parameter Section
parameter Real T(unit="C")=65                    "Normal boiling point";
parameter Real M(unit="Kg/Kmol")=32              "Molecular weight"; 
parameter Real Kv(unit="nil")=0.29               "Coefficient";

//===================
// Variable Section
Real rhov(unit="Kg/m^3")         "Vapour density";
Real uc(unit="m/s")              "Vapour velocity";
Real F(unit="(m/s)*(Kg/m^3)^0.5")"F factor";      

//==================
//Equation  Section 
equation
rhov= (M*273)/(22.4*338);
uc= (Kv*((750-1.15)/1.15)^0.5*(19/20)^0.2)*0.3048; //0.3048 is used for conversion from ft to m.
F=uc*sqrt(rhov);

end Ex21_8;
