//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 22: Introduction to Multicomponent Distillation.
//Example  : 22.5 Pg 759
//Title: Fractionation of multicomponent mixtures. 
//================================================================================================

model Ex22_5
 //A table is mentioned in Pg759 where all the parameters are mentioned.They are sae as Ex22_3

//===================
// Parameter Section
parameter Real xF(unit="nil")=0.33          "Mole fraction of hexane";
parameter Real xD(unit="nil")=0.99          "Mole fraction of hexane at the top";
parameter Real xB(unit="nil")=0.01          "Mole fraction of hexane at the bottom";
parameter Real y(unit="nil")=0.41           
"Variable to represent (RD-RDm)/(RD+1), Its taken from Fig22.5 Pg757";
parameter Real Nmin(unit="nil")=10.4        "Minimum number of ideal stages";
parameter Real fi(unit="nil")=1.45; 

//===================
// Variable Section
Real RDm(unit="nil")            "Minimum reflux ratio";          
Real RD(unit="nil")             "Reflux ratio";
Real x(unit="nil")              "Variable to represent (RD-RDm)/(RD+1)";
Real N(unit="nil")              "Number of stages";
Real N1(unit="nil")             "Number of stages";

//==================
//Equation  Section 
equation
RDm+1= ((2.21*xD)/(2.21-1.45))+((1*0.01)/(1-1.45));
RD=1.5*RDm;
x=(RD-RDm)/(RD+1);
y=(N-Nmin)/(N+1);
N1=Nmin*1.8; //1.8 taken from Fig22.6 Pg758

end Ex22_5;
