//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 23: Leaching and extraction.
//Example  : 23.1 Pg 769
//Title: Leaching.
//================================================================================================

package Ex23_1
model Ex23_1_1234
//A table is mentioned in Pg770.
//===================
// Parameter Section
parameter Real F(unit="Kg")=1000        "Feed amount";
parameter Real xn(unit="nil")=0.3       "Mole fraction";
parameter Real x1(unit="nil")=0.6       "Mole fraction";
parameter Real L(unit="Kg/h")=60        "Amount of unextracted oil";
parameter Real L1(unit="Kg/h")=400      "Amount of oil in untreated meal";
parameter Real L2(unit="Kg/h")=25       "Amount of benzene in meal";

//===================
// Variable Section
Real Lb(unit="Kg/h")           "Liquid flow rate";
Real Lb1(unit="Kg/h")          "Liquid flow rate";
Real La(unit="Kg/h")           "Liquid flow rate";
Real x(unit="Kg/h")            "Variable to represent Oil in extract";
Real y(unit="Kg/h")            "Variable to represent benzene in extract";   
Real xb(unit="nil")            "Mass fraction of oil in entrance";
Real xa(unit="nil")            "Mass fraction of oil in underflow";
Real yb(unit="nil")            "Mass fraction of oil in entrance";
Real Vb(unit="Kg/h")           "Moles of mixture In cascade";
Real ya(unit="nil")            "Mass fraction of oil in overflow";
Real Va(unit="Kg/h")           "Moles of mixture In cascade";

//==================
//Equation  Section 
equation
Vb=10+655;
yb=10/Vb;
Lb=0.505*F; //0.505 is taken from Table 23.1 Pg770.
xb=L/Lb;
Lb1=Lb-L;
La=L1+L2;
xa=L1/La;
x=10+L1-L;
y=655+25-447; //447 is benzene in underflow
Va=x+y;
ya=x/Va;

end Ex23_1_1234;

model Ex23_1_5
//A table is mentioned in Pg770.
//===================
// Parameter Section
parameter Real F(unit="Kg")=1000        "Feed amount";
parameter Real xn(unit="nil")=0.3       "Mole fraction";
parameter Real x1(unit="nil")=0.6       "Mole fraction";
parameter Real L(unit="Kg/h")=60        "Amount of unextracted oil";
parameter Real L1(unit="Kg/h")=400      "Amount of oil in untreated meal";
parameter Real L2(unit="Kg/h")=25       "Amount of benzene in meal";
parameter Real Va(unit="Kg/h")=583      "Mass of extract";
parameter Real La(unit="Kg/h")=425      "Volume at solid inlet"; 
parameter Real ya(unit="nil")=0.6       "Mass fraction";
parameter Real xa(unit="nil")=0.941     "Mass fraction";

//===================
// Variable Section
Real Lx(unit="Kg/h")           "Solution retained";
Real y2(unit="nil")            "Mass fraction of oil in overflow";
Real V2(unit="Kg/h")           "Moles of mixture In exit";
Real Ln(unit="Kg/h")           "Solution retained";
Real Vstar(unit="Kg/h")        "Varaiable to represent Vn+1";
Real ystar(unit="nil")         "Mole fraction, Varaiable to represent yn+1";


//==================
//Equation  Section 
equation
Lx=0.595*F; //In Text book the fraction is considered wrongly.
V2=Lx+Va-La;
V2*y2=(Lx*x1)+(Va*ya)-(La*xa);
Ln=0.53*F;
Vstar=Ln+Va-La;
(ystar*Vstar)=(Ln*xn)+(Va*ya)-(La*xa);

end Ex23_1_5;

end Ex23_1;
