//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 24: Drying of solids
//Example  : 24.3 Pg 820
//Title:  Drying equipment
//================================================================================================
model Ex24_3

//===================
// Parameter Section

parameter Real m(unit = "lb/h") = 2800 "Mass flowrate of initial solid";
parameter Real X_a(unit = "NA") = 0.15 "Percentage of initial moisture content";
parameter Real X_b(unit = "NA") = 0.005 "Percentage of final moisture content";
parameter Real Cp_s(unit = "Btu/lb.°F") = 0.52 "Specific heat of the entering solid";
parameter Real Cp_v(unit = "Btu/lb.°F") = 0.45 "Specific heat of the vapour";
parameter Real T_1(unit = "°F") = 80 "Temperature of the entering solid";
parameter Real T_2(unit = "°F") = 125 "Temperature of the exiting solid";
parameter Real T_a(unit = "°F") = 260 "Temperature of the air";
parameter Real G(unit = "lb/ft2.h") = 700 "Mass velocity of the air";
parameter Real T_w(unit = "°F") = 102 "Wet bulb temperature of entering air";
parameter Real l(unit = "Btu/lb") = 1036 "Heat capacity of the system";
parameter Real H_b(unit = "lb of water/lb of dry air") = 0.01 "Humidity of air entering";
parameter Real N_t(unit = "NA") = 1.5 "Number of transfer units";
parameter Real Cp_l(unit = "Btu/lb.°F") = 1 "Number of transfer units";
parameter Real C_sb(unit = "Btu/lb.°F") = 0.245 "Specific heat of the exiting solid";

//===================
// Library Section

extends Modelica.Math;
extends Modelica.Constants;

//===================
// Variables Section

Real T_ha(unit = "°F") "Outlet temperature of air";
Real m_v(unit = "lb/h") "Mass flowrate of vapour";
Real q_t(unit = "Btu/lb") "Heat duty of the system";
Real H_a(unit = "lb of water/lb of dry air") "Humidity of outlet air";
Real m_g(unit = "lb/h") "Mass flowrate of entering air";
Real D(unit = "ft") "Diameter of the dryer";
Real delT(unit = "°F") "Logarithmic mean temperature differnce";
Real L(unit = "ft") "Length of the dryer";


//==================
//Equation  Section 

equation

T_ha = ( (T_a - T_w) / exp(N_t) ) + T_w;
m_v = m * (X_a - X_b);
q_t = m * ( Cp_s * (T_2 - T_1) + X_a * Cp_l * (T_w - T_1) + (X_a - X_b) * l + X_b * Cp_l * (T_2 - T_w) + (X_a - X_b) * Cp_v * (T_ha - T_w) );
m_g = (q_t / (C_sb * (T_a - T_ha)))/(1 + H_b) ; 
H_a = H_b + (m_v / m_g);
D = ( (4 * m_g * (1 + H_b) / G) / pi )^0.5;
delT = ( T_a - T_w - (T_ha - T_w) ) / log( (T_a - T_w) / (T_ha - T_w) );
L = q_t / (0.125 * pi * D * G^0.67 * delT); 
end Ex24_3;
