//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 25: Asorption and fixed bed separations
//Example  : 25.5 Pg 861
//Title:  adsorption equipment
//================================================================================================
model Ex25_5

//===================
// Parameter Section

parameter Real W_sat(unit = "lb/lb") = 0.2 "Saturation capcity of the water";
parameter Real E(unit = "NA") = 0.85 "Percentage of TCE regenerated";
parameter Real V(unit = "gal/min.ft2") = 4.5 "Flowrate of water";
parameter Real c1(unit = "gal/ft3") = 7.48 "Conversion factor";
parameter Real rho(unit = "g/cm3") = 0.53 "Density of adsorbent";
parameter Real l(unit = "ft") = 2 "Length of the bed";
parameter Real lub(unit = "ft") = 0.6 "Length of the unused bed";
parameter Real c2(unit = "min/h") = 60 "Conversion factor";
parameter Real M(unit = "") = 62.4 "";
parameter Real X(unit = "ppm") = 1.2 "Amount of TCE contamination";

//===================
// Variable Section 

Real W_o(unit = "lb/lb") "Initial capacity of the water";
Real u_o(unit = "ft/h") "Velocity of water";
Real t_star(unit = "h") "";
Real t_b(unit = "h") "Breakthrough time";
Real V_b(unit = "NA") "Bed volumes treated";

//===================
// Equation Section

equation

W_o = (1 - E) * W_sat;
u_o = V * c2 / c1;
t_star = ( l * rho * M * (W_sat - W_o) ) / (u_o * X * 10^(-6) * M);
t_b = t_star * ( 1 - (lub/l) );
V_b = (u_o * t_b / l);
end Ex25_5;
