//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 26: Membrane separation process.
//Example  : 26.4 Pg 919
//Title: Pervapouration
//================================================================================================

model Ex26_4
//===================
// Parameter Section
parameter Real di(unit="m")=200*10^(-6)     "Diameter";
parameter Real do(unit="m")=300*10^(-6)     "Diameter";
parameter Real x(unit="gal/ft^2.day")=10    "Water flux";
parameter Real Ds(unit="cm^2/s")=1.6*10^(-5)"Diffusivity";

//===================
// Variable Section
Real Jw(unit="cm/s")     "Flux";
Real Re(unit="nil")      "Reynolds number";
Real Sc(unit="nil")      "Schmidth number";
Real Sh(unit="nil")      "Sherwood number";
Real kc(unit="cm/s");
Real tou(unit="nil");

//==================
//Equation  Section 
equation
Jw=10*(231*16.3871)/(24*3600*929);
Re=(3*10^(-2)*0.5)/0.01;
Sc=0.01/(Ds*1);
Sh=1.28*(Re)^0.4*(Sc)^0.33;
kc=Sh*Ds/0.03;
tou=Jw*0.97/kc;

end Ex26_4;
