//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 26: Membrane separation process.
//Example  : 26.5 Pg 921
//Title: Pervapouration
//================================================================================================

model Ex26_5
//===================
// Parameter Section
parameter Real di(unit="m")=200*10^(-6)     "Diameter";
parameter Real do(unit="m")=300*10^(-6)     "Diameter";
parameter Real mu(unit="Pa.s")=1*10^(-3)    "Viscosity";

//===================
// Variable Section
Real Jw(unit="m/s")        "Flux";
Real deltaps(unit="Pa")     "Pressure difference";
Real Vbar(unit="m/s")       "Velocity";
Real deltap(unit="atm")     "Pressure difference";

//==================
//Equation  Section 
equation
Jw=(4.72*10^(-4)*10^(-2))*(do/di);
Vbar=(4*Jw*3)/di;
deltaps=(Vbar*32*3*10^(-3))/((2*10^(-4))^2*2); //In T.B its given 5.1*10^5 Here we get 509760.
deltap=5.03/4;

end Ex26_5;
