//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 27: Crystallization.
//Example  : 27.1 Pg 934
//Title: Equilibiria and yields.
//================================================================================================

model Ex27_1

// From Fig27.3 Pg933, all the required values are taken.
//===================
// Parameter Section
parameter Real T(unit="F")=60            "Cooling temperature";
parameter Real F(unit="Kg")=1000         "Feed";
parameter Real M1(unit="Kg/Kgmol")=120.4 "Molecular weight of MgSO4"; 
parameter Real M2(unit="Kg/Kgmol")=246.5 "Molecular weight of MgSO4.7H2O"; 

//===================
// Variable Section
Real x1(unit="Kg")    "Amount of water in feed";
Real x2(unit="Kg")    "Amount of water evaporated";
Real x3(unit="Kg")    "Amount of MgSO4.7H2O ";
Real x4(unit="Kg")    "Amount of free water ";
Real x5(unit="Kg")    "Amount ofMgSO4.7H2O in 100Kg of mother liquor" ;
Real x6(unit="Kg")    "Amount of free water in 100 Kg of liquor";
Real x7(unit="Kg")    "Amount of MgSO4.7H2O in mother liquor";
Real x8(unit="Kg")    "Amount of the final crop";

//==================
//Equation  Section 
equation
x1=0.7*F;
x2=0.05*x1;
x3=F*0.3*(M2/M1);
x4=F-x3-35;
x5=24.5*(M2/M1);
x6=100-x5;
x7=(x5/x6)*x4;
x8=x3-x7;

end Ex27_1;
