//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 27: Crystallization.
//Example  : 27.2 Pg 935
//Title: Equilibiria and yields.
//================================================================================================

model Ex27_2

// From Fig27.4 ,required values are taken.
//===================
// Parameter Section
parameter Real T1(unit="F")=120            "Initial temperature";
parameter Real T2(unit="F")=70             "Final temperature";

//===================
// Variable Section
Real H(unit="Btu")        "Change in enthalpy";
Real x(unit="lb")         "Amount of crystals";
Real H1(unit="Btu/ton")   "Heat evolved per ton of crystals";

//==================
//Equation  Section 
equation
H=100*(33.0-78.4);
x=100*((0.325-0.259)/(0.488-0.259));
H1= (-H/x)*2000;


end Ex27_2;
