//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 27: Crystallization.
//Example  : 27.4 Pg 943
//Title: Nucleation.
//================================================================================================

model Ex27_4
//All parameters are same as in Ex27_3
 
//===================
// Parameter Section
parameter Real sigmaa(unit="ergs/cm^2")=2.5    "Interfacial surface tension";     
parameter Real rho(unit="g/cm^3")=1.988        "Density of the crystal";
parameter Real M(unit="g/gmole")=74.56         "Molecular weight of KCl";
parameter Real nu(unit="nil")=2                "Number of ions";
parameter Real B(unit="nil")=1                 "Nucleation rate";

//===================
// Variable Section
Real VM(unit="cm^3/gmol")      "Molar volume";
Real alpha(unit="nil")         "Concentration ratio";
Real L(unit="cm")              "Size of nucleus";

//==================
//Equation  Section 
equation
VM= M/rho;
alpha=1+0.029;
log(1.029)= (4*VM*sigmaa)/(nu*8.3143*10^7*(300*L));

end Ex27_4;
