//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 27: Crystallization.
//Example  : 27.5 Pg 953
//Title: Crystal growth.
//================================================================================================

model Ex27_5
//From Fig27.12 Pg953 required values are taken, steam tables is also used for certain values
//===================
// Parameter Section
parameter Real T(unit="F")=86                   "Temperature";
parameter Real T1(unit="F")=2                   "Boiling point elevation";
parameter Real rho1(unit="lb/ft^3")=105         "Density of the crystal";
parameter Real rho2(unit="lb/ft^3")=82.5        "Density of the liquor";

//===================
// Variable Section
Real x(unit="nil")      "Variable to represent mass ratio of crystals";
Real C(unit="nil")      "Average concentration of MgSO4 in magma";
Real F(unit="lb/h")     "Rate of production of mother liquor";
Real F1(unit="lb/h")    "Total feed rate";
Real F2(unit="lb/h")    "Total magma produced";
Real H(unit="Btu/lb")   "Enthalpy of magma";
Real E(unit="lb/h")     "Evaporation rate";

//==================
//Equation  Section 
equation
x=(0.15*rho1)/(0.85*rho2);
F= 10000/x;
C=((x*0.488)+0.285)/1.224;
F2=F+10000;
H=(x*(-149)+(-43))/1.224;
E=F2*((-21)-(-62.4))/(1098-(-21));
F1=F2+E;

end Ex27_5;
