//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 28: Properties and handling of particulate solids.
//Example  : 28.1 Pg 973
//Title: Characterization of solid particles. 
//================================================================================================

package Ex28_1
model Ex28_1_1
//===================
// Parameter Section

// The data for this question is in Table 28.1 Pg 972
parameter Real rhop(unit="g/mm^3")=0.00265   "Density of particles";
parameter Real a(unit="nil")=0.8             "Shape factor";
parameter Real fi(unit="nil")=0.571          "Sphericity";
parameter Real x2(unit="nil")=0.0031         "Mass fraction retained in 200th mesh";
parameter Real Dp2(unit="mm")=0.089          "Average particle diameter in 200th mesh";

//===================
// Variable Section
Real Aw(unit="mm^2/g")       "Specific surface area";
Real Nw(unit="particles/g")  "Number of particles";

//==================
//Equation  Section 
equation
Aw=(6/(fi*rhop))*(0.8284/0.9925); 
//(0.8284/0.9925) is the value of summation of (xi/Dpi)/(1-x1)from table 28.1
Nw= (1/(a*rhop))*(8.8296/0.9925); 
//(8.8296/0.9925) is the value of summation of (xi/Dpi^3)/(1-x1)from table 28.1 

end Ex28_1_1;

model Ex28_1_2
//===================
// Parameter Section

// The data for this question is in Table 28.1 Pg 972
parameter Real rhop(unit="g/mm^3")=0.00265   "Density of particles";
parameter Real a(unit="nil")=0.8             "Shape factor";
parameter Real fi(unit="nil")=0.571          "Sphericity";
parameter Real x2(unit="nil")=0.0031         "Mass fraction retained in 200th mesh";
parameter Real Dp2(unit="mm")=0.089          "Average particle diameter in 200th mesh";

//===================
// Variable Section
Real Dv(unit="mm")           "Volume mean diameter";

//==================
//Equation  Section 
equation
Dv= (1/(8.8296)^(1/3));

end Ex28_1_2;

model Ex28_1_3
//===================
// Parameter Section

// The data for this question is in Table 28.1 Pg 972
parameter Real rhop(unit="g/mm^3")=0.00265   "Density of particles";
parameter Real a(unit="nil")=0.8             "Shape factor";
parameter Real fi(unit="nil")=0.571          "Sphericity";
parameter Real x2(unit="nil")=0.0031         "Mass fraction retained in 200th mesh";
parameter Real Dp2(unit="mm")=0.089          "Average particle diameter in 200th mesh";

//===================
// Variable Section
Real Ds(unit="mm")           "Volume-surface mean diameter";

//==================
//Equation  Section 
equation
Ds= (1/0.8284);

end Ex28_1_3;

model Ex28_1_4
//===================
// Parameter Section

// The data for this question is in Table 28.1 Pg 972
parameter Real rhop(unit="g/mm^3")=0.00265   "Density of particles";
parameter Real a(unit="nil")=0.8             "Shape factor";
parameter Real fi(unit="nil")=0.571          "Sphericity";
parameter Real x2(unit="nil")=0.0031         "Mass fraction retained in 200th mesh";
parameter Real Dp2(unit="mm")=0.089          "Average particle diameter in 200th mesh";

//===================
// Variable Section
Real Dw(unit="mm")           "Masss mean diameter";

//==================
//Equation  Section 
equation
Dw= 1.677; //Summation of xi*Dpi=1.677

end Ex28_1_4;

model Ex28_1_5
//===================
// Parameter Section

// The data for this question is in Table 28.1 Pg 972
parameter Real rhop(unit="g/mm^3")=0.00265   "Density of particles";
parameter Real a(unit="nil")=0.8             "Shape factor";
parameter Real fi(unit="nil")=0.571          "Sphericity";
parameter Real x2(unit="nil")=0.0031         "Mass fraction retained in 200th mesh";
parameter Real Dp2(unit="mm")=0.089          "Average particle diameter in 200th mesh";

//===================
// Variable Section
Real N2(unit="particles/g")  "Number of particles in the 150/200 mesh increment ";

//==================
//Equation  Section 
equation
N2= (x2/(a*rhop*(Dp2)^3));

end Ex28_1_5;

end Ex28_1;
