//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 29: Mechanical separations.
//Example  : 29.4 Pg 1052
//Title: Cross-flow filtration -membrane filters.
//================================================================================================

package Ex29_4
model Ex29_4_1
//===================
// Parameter Section
parameter Real Re(unit="nil")=25000         "Reynolds number";
parameter Real M(unit="nil")=30000          "Molecular weight";
parameter Real epsilon(unit="nil")=0.5      "Void";
parameter Real tou(unit="nil")=2            "Tortuosity factor";
parameter Real Dpore(unit="cm^2/s")=1*10^(-7)"Diffusuvity of pore";
parameter Real D(unit="cm^2/s")=5*10^(-7)   "Diffusuvity";
parameter Real lamda1(unit="nil")=0.682     "Ratio of molecular size to pore size";
parameter Real De(unit="cm^2/s")=2.5*10^(-8)"Effective Diffusivity";
parameter Real L(unit="cm")=2*10^(-5)       "Length" ;

//===================
// Variable Section
Real nu(unit="cm/s")        "Volume flux";
Real Sc(unit="nil")         "Schmidth number";
Real Sh(unit="nil")         "Sherwood number";
Real K(unit="nil")          "Equilibirium coefficient";
Real kc(unit="cm/s")        "Mass transfer coefficient";
Real R(unit="nil")          "Fraction  of solute remaining";
Real Rmax(unit="nil")       "Fraction  of solute remaining";

//==================
//Equation  Section 
equation
nu=40*2.78*10^(-5);
Sc=0.01/D;
Sh=0.0096*(Re)^0.913*(Sc)^0.346;
kc=Sh*D/1.5;
(0.25/0.75)=(K/(1-K))*exp(nu/kc);
((1-R)/R)= (K/0.899)*exp(0.556/1.02);
Rmax=1-K;

end Ex29_4_1;

model Ex29_4_2
//===================
// Parameter Section
parameter Real Re(unit="nil")=25000         "Reynolds number";
parameter Real M(unit="nil")=30000          "Molecular weight";
parameter Real epsilon(unit="nil")=0.5      "Void";
parameter Real tou(unit="nil")=2            "Tortuosity factor";
parameter Real Dpore(unit="cm^2/s")=1*10^(-7)"Diffusuvity of pore";
parameter Real D(unit="cm^2/s")=5*10^(-7)   "Diffusuvity";
parameter Real lamda1(unit="nil")=0.682     "Ratio of molecular size to pore size";
parameter Real De(unit="cm^2/s")=2.5*10^(-8)"Effective Diffusivity";
parameter Real L(unit="cm")=2*10^(-5)       "Length" ;

//===================
// Variable Section
Real kc2(unit="cm/s")       "Mass transfer coefficient";
Real K2(unit="nil")         "Equilibirium coefficient";
Real R2(unit="nil")         "Fraction  of solute remaining";
Real lamda2(unit="nil")     "Ratio of molecular size to pore size";

//==================
//Equation  Section 
equation
//Fig 29.21 is used for taking certain values.
lamda2=lamda1*0.694;
K2=(1-lamda2)^2;
kc2=1.02*10^(-3)*3^0.22;
((1-R2)/R2)=(K2/(1-K2))*exp(1.112/1.29);

end Ex29_4_2;

model Ex29_4_3
//===================
// Parameter Section
parameter Real Re(unit="nil")=25000         "Reynolds number";
parameter Real M(unit="nil")=30000          "Molecular weight";
parameter Real epsilon(unit="nil")=0.5      "Void";
parameter Real tou(unit="nil")=2            "Tortuosity factor";
parameter Real Dpore(unit="cm^2/s")=1*10^(-7)"Diffusuvity of pore";
parameter Real D(unit="cm^2/s")=5*10^(-7)   "Diffusuvity";
parameter Real lamda1(unit="nil")=0.682     "Ratio of molecular size to pore size";
parameter Real De(unit="cm^2/s")=2.5*10^(-8)"Effective Diffusivity";
parameter Real L(unit="cm")=2*10^(-5)       "Length" ;

//===================
// Variable Section
Real X(unit="nil")          "Variable to represent nuL/De";
Real Y(unit="nil")          "Variable to represent c2/cs";

//==================
//Equation  Section 
equation
X=(5.56*10^(-4)*L)/De;
Y=(0.101*exp(X))/(0.101-1+exp(X));

end Ex29_4_3;

end Ex29_4;
