//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 4: Basic Equations of Fluid Flow 
//Example  : 4.4 Pg 88
//Title: Mechanical Energy Equation
//================================================================================================

model Ex4_4

//===================
// Parameter Section

parameter Real Za(unit="m") = 5           "Height at point a";
parameter Real Zb(unit="m") = 0           "Height at point b";
parameter Real Pa(unit="atm") = 1         "Pressure at point a";
parameter Real Pb(unit="atm") = 1         "Pressure at point b";
parameter Real g(unit="m/s2") = 9.80665   "Acceleration due to gravity";

//===================
// Variable Section 

Real ub(unit="m/s") "Discharge velocity";

//==================
// Equation  Section 
 equation
 ((Za*g)/(0.5))^0.5 = ub;

end Ex4_4;

//====================================================================================================
