//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 4: Basic Equations of Fluid Flow 
//Example  : 4.5 Pg 91
//Title: Mechanical Energy Equation
//================================================================================================

package Ex4_5
model Ex4_5_1
//===================
// Parameter Section
parameter Real rho(unit ="kg/m3") = 998 "Density of water";
parameter Real Va(unit = "m/s") = 1     "Velocity at the inlet";
parameter Real Pa(unit = "kN/m2") = 100 "pressure at the inlet";
parameter Real Da(unit = "mm") = 50     "Diameter at the inlet";
parameter Real Db(unit = "mm") = 20     "Diameter at the outlet";


//===================
    // Variable Section

Real Pb(unit = "kN/m2")  "Pressure at the outlet";
Real Vb(unit = "m/s")    "Velocity at the outlet";

//==================
// Equation  Section 
 equation
 Vb = Va*(Da/Db)^2; 
 Pb = Pa - (rho*(Vb^2-Va^2))/2000;
 

end Ex4_5_1;

model Ex4_5_2
extends Modelica.Constants;

//===================
// Parameter Section
parameter Real rho(unit ="kg/m3") = 998 "Density of water";
parameter Real Va(unit = "m/s") = 1     "Velocity at the inlet";
parameter Real Pa(unit = "kN/m2") = 100 "pressure at the inlet";
parameter Real Da(unit = "mm") = 50     "Diameter at the inlet";
parameter Real Db(unit = "mm") = 20     "Diameter at the outlet";
parameter Real Vby(unit="m/s")=4.42     "Velocity";

//===================
    // Variable Section
    Real Sa(unit="m^2")    "Area";
Real Sbx(unit="m^2")    "Area";
Real Vbx(unit="m/s")   "Velocity";
Real m(unit="Kg/s")    "Mass flow rate";
Real Fwx(unit="N")     "Force";   
Real Fwy(unit="N")     "Force";

//==================
// Equation  Section 
 equation
Sa= (pi/4)*0.050^2;
Vbx=6.25*cos(pi/4);
Sbx=(pi/4)*(0.02^2)*cos(pi/4);
m=Sa*1*998;
Fwx=m*(4.42-1)-(100000*Sa)+(81010*Sbx);
Fwy=m*((1*Vby)-(1*0))-(81.01*Sa)+(1*Sbx) +17.98; //Sbx=Sby.

end Ex4_5_2;

end Ex4_5;
