//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 4: Basic Equations of Fluid Flow 
//Example  : 4.6 Pg 93
//Title: Pump Work in Bernoulli Equation
//================================================================================================

model Ex4_6

//===================
// Parameter Section

parameter Real sg(unit = "nil") = 1.84         "Specific gravity of the fluid";
parameter Real Va(unit = "ft/s") = 3           "velocity at the inlet";
parameter Real Da(unit = "inch") = 3           "Inlet Diameter";
parameter Real Db(unit = "inch") = 2           "Outlet Diameter";
parameter Real hf(unit = "nil") = 10           "friction losses";
parameter Real a1(unit = "ft^2")= 0.0513        "Inlet area";
parameter Real a2(unit = "ft^2")= 0.0233        "Outlet area";
parameter Real Zb(unit = "ft") = 50            "Height from the pipe";
parameter Real g(unit = "ft/s2") = 32.174      "Acceleration due to gravity";
parameter Real gc(unit = "ft.lb/lb.s2")=32.174 "Newton's law propotionality factor";

//===================
// Variable Section
Real m(unit = "lb/s")       "Mass flow rate"; 
Real Vb(unit = "ft/s")      "Velocity at the oultet";
Real Wp(unit = "ft.lb/lb")  "Work done by the pump";
Real deltaP(unit="lb/ft^2") "Pressure developed by the pump";
Real P(unit = "hp")         "Power ";
Real P1(unit = "hp")        "Power delivered to the fluid";

//==================
// Equation  Section 
equation
 Vb = (a1*Va)/a2;
 0.6*Wp = (50*(g/gc)+(Vb^2/64.34)+10);
 deltaP=(sg*62.37*(((Va^2-Vb^2)/(2*gc))+60.68)); //deltaP=Pb-Pa.
 m = (a1*3*sg*62.37);    // density= sg *62.37
 P = (m*Wp)/550;         // 1 hp=550 ft.lb/s
 P1=P*0.6;
end Ex4_6;

//================================================================================================
