//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 5: Incompressible Flow in Pipes and Channels
//Example  : 5.2 Pg 125
//Title: Friction from changes in velocity or direction.
//================================================================================================

model Ex5_2

//===================
// Parameter Section
parameter Real mu(unit = "cP") = 4              "Viscosity of crude oil";
parameter Real sg(unit = "no unit") = 0.93      "Viscosity of water";
parameter Real h(unit = "m") = 6                "Depth of liquid";
parameter Real L(unit = "m") = 45               "Length of pipe";
parameter Real Sc(unit = "no unit")=40          "Schedule number of pipe";
parameter Real d(unit = "inch") = 3             "Diameter of pipe";
parameter Real g(unit = "m/s^2") = 9.80566      "Acceleration due to gravity";
parameter Real Za(unit = "m") = 6               "Height of liquid at a";
parameter Real Zb(unit = "m") = 9               "Height of liquid at b";
parameter Real Kc(unit = "no unit") = 0.4       "Contraction loss coefficent";
parameter Real Kf(unit = "no unit") = 1.09      "loss factor for fitting";
parameter Real D(unit = "m") = 0.078            "Diameter of pipe";
parameter Real a(unit = "m^2") =0.00477         "Area of the pipe";
parameter Real f(unit = "no unit")=0.0055       "Friction factor";

//===================
// Variable Section

Real q(unit = "m^3/h")      "Flowrate of oil";
Real vb(unit = "m/s")        "velocity of oil";
Real hf(unit = "no unit")   "Frictional losses";

//==================
// Equation  Section 
 equation
 (vb^2/2) +hf = 147.1;    //hf = ((2308*f) + 1.49)((v^2/2). Substitute hf in this equation.
 (vb^2/2) = 147.1/(2.49 + 2308*f); 
 q= (vb*a*3600);


end Ex5_2;
