//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 6: Flow of Compressible Fluids.
//Example  : 6.2 Pg 148
//Title: Adiabatic Friction Flow. 
//================================================================================================

package Ex6_2
model Ex6_2_1
//===================
// Parameter Section
parameter Real T(unit = "K")= 555.6                         "Temperature of air equivalent to 1000 R";
parameter Real P(unit = "atm")= 20                          "Pressure of air";
parameter Real Ma(unit = "nil")= 0.05                       "Mach number at the entrance";
parameter Real gamma(unit = "nil")= 1.4                     "Gamma of air";

//===================
// Variable Section
Real X(unit="nil")                      "X=(f*L)/r == Variable which needs to be found out";

//==================
//Equation  Section 
equation
X = (1/gamma)*((1/Ma^2)-(1)-((1.4+1)/2)*log(2*(1+((1.4-1)/2)*Ma^2)/(Ma^2*(1.4+1))));

end Ex6_2_1;

model Ex6_2_2
//===================
// Parameter Section
parameter Real T(unit = "K")= 555.6                         "Temperature of air equivalent to 1000 R";
parameter Real P(unit = "atm")= 20                          "Pressure of air";
parameter Real Ma(unit = "nil")= 0.05                       "Mach number at the entrance";
parameter Real gamma(unit = "nil")= 1.4                     "Gamma of air";

//===================
// Variable Section
Real Tstar(unit="R")                       "Temperature";
Real ua(unit="ft/s")                    "Linear velocity";
Real Pstar(unit="atm")                     "Pressure";
Real ustar(unit="ft/s")                  "velocity";
Real rhostar(unit="kg/m^3")                "Density";
Real aa(unit="ft/s")                    "Accoustic velocity";

//==================
//Equation  Section 
equation
aa=sqrt(1.4*32.174*1000*(1545/29)); //32.174 is acceleration due to gravity in appropriate units & 29 is molecular weight of air
ua=aa*0.05;
(1000/Tstar) = 1.2; //24/(2*(1+((1.4-1)/2)*0.05^2))=1.2;
(0.795/rhostar)= (1/Ma)*(sqrt((2*(1+((1.4-1)/2)*0.05^2))/2.4)); //0.795 is density
(20/Pstar)= (1/Ma)*sqrt(1.2);
ustar*0.0435= 0.795*ua;

end Ex6_2_2;

model Ex6_2_3
//===================
// Parameter Section
parameter Real T(unit = "K")= 555.6                         "Temperature of air equivalent to 1000 R";
parameter Real P(unit = "atm")= 20                          "Pressure of air";
parameter Real Ma(unit = "nil")= 0.05                       "Mach number at the entrance";
parameter Real gamma(unit = "nil")= 1.4                     "Gamma of air";

//===================
// Variable Section
Real ua1(unit="ft/s")                    "Linear velocity for new mach number";
Real Maa(unit = "nil")                  "Mach number ";
Real G2(unit="lb/ft^2.s")               "Mass velocity";
Real ua(unit="ft/s")                    "Linear velocity";
Real aa(unit="ft/s")                    "Accoustic velocity";

//==================
//Equation  Section 
equation
aa=sqrt(1.4*32.174*1000*(1545/29)); //32.174 is acceleration due to gravity in appropriate units & 29 is molecular weight of air
ua=aa*0.05;
400=(1/gamma)*((1/(Maa)^2)-1-((1.4+1)/2)*log((2*(1+((1.4-1)/2)*(Maa)^2)/((Maa)^2*(1.4+1)))));               //(f*L)/r =400 & Ma1 is found out.
ua1= Maa*ua/0.05;
G2=0.795*ua1;


end Ex6_2_3;


end Ex6_2;
