//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 6: Flow of Compressible Fluids.
//Example  : 6.3 Pg 150
//Title: Isothermal Friction Flow. 
//================================================================================================

model Ex6_3

extends Modelica.Constants;
//===================
// Parameter Section

parameter Real T(unit = "K")= 288                         "Temperature of air";
parameter Real Pa(unit = "atm")= 2.7                      "Gauge=1.7, absolute pr=2.7";
parameter Real mu(unit="kg.m/s")=1.74*10^(-5)             "viscosity";
parameter Real D(unit="m")=0.075                          "Diameter of pipe";
parameter Real rh(unit="m")=0.01875                       "Hydraulic radius. rh=D/4";
parameter Real q(unit="m^3/s")=0.265                      "Flowrate of air";
parameter Real f(unit="nil")=0.0044                       "friction factor,from Fig 5.10 Pg 115";
parameter Real R(unit="m^3.atm/Kgmol.K")=82.056*10^(-3)   "Gas constant";
parameter Real L(unit="m")=70                             "Length of pipe";
parameter Real M(unit="Kg/Kmol")=29                       "Molecular weight of air";

//===================
// Variable Section
Real rhoa(unit="Kg/m^3")    "Density of air";
Real A(unit="m^2")          "Area A=(3.14/4)*D^2";
Real G(unit="Kg/m^2.s")     "Mass velocity";
Real Re(unit="nil")         "Reynolds number";
Real Pb(unit="atm")         "Pressure at discharge";
Real Pavg(unit="atm")       "Average pressure";

//==================
//Equation  Section 
equation
A=(pi*0.075^2)/4;
rhoa=(29/22.4)*(2.7/1)*(273/288);
G=(q*rhoa)/A;
Re=(D*G)/mu; //Re no otained is 856701. IN textook its given as 8.56*10^5.
(Pa - Pb)=((R*T*G^2)/(M*1.982*101325))*(((f*L)/(2*rh))+(log(Pa/Pb)));
Pavg=(Pa+Pb)/2;

end Ex6_3;
