//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 7: Flow past Immersed objects.
//Example  : 7.2 Pg 174
//Title: Motion of particles through fluids. 
//================================================================================================

model Ex7_2


//===================
// Parameter Section
parameter Real d(unit="inch")=0.004            "Diameter of sphalerite particle";
parameter Real sg1(unit="nil")=4               "Specific gravity of sphalerite";
parameter Real sg2(unit="nil")=1.594           "Specific gravity of CCl4";
parameter Real epsilon(unit="nil")=0.2         "Volume fraction of spalerite in CCl4";
parameter Real rho1(unit="lb/ft^3")=99.42      "Density of CCl4";
parameter Real rhodiff(unit="lb/ft^3")=150.06  "Density difference";
parameter Real mu(unit="cP")=1.03              "Viscosity of CCl4";
parameter Real g(unit="ft/s^2")=32.174         "Acceleration due to gravity";

//===================
// Variable Section
Real K(unit="nil")              "It denotes the regime";
Real ut(unit="ft/s")             "Terminal settling velocity";
Real Rep(unit="nil")            "Reynolds number";
Real us(unit="ft/s")            "settling velocity";

//==================
//Equation  Section 
equation
K=(d/12)*((g*rho1*rhodiff)/(1.03*6.72*10^(-4))^2)^(1/3); //Viscosity is converted to appropriate units 
ut= (g*(d/12)^2*rhodiff)/(18*1.03*6.72*10^(-4));
Rep= ((d/12)*ut*rho1)/(1.03*6.72*10^(-4));
us= (ut*0.8^4.1); //0.8=1-epsilon,n=4.1 (obtained from Fig 7.8, n vs Rep pg174)


end Ex7_2;
