//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 8: Transportation and metering of fluids.
//Example  : 8.4 Pg 230
//Title: Measurement of flowing fluids. 
//================================================================================================

package Ex8_4
model Ex8_4_1
//===================
// Parameter Section
// o denotes orifice.

parameter Real q(unit="m^3/s")=0.0139    "Flowrate ";
parameter Real g(unit="m/s^2")=9.80665   "Acceleration due to gravity";
parameter Real Co(unit="nil")=0.61       "Coefficient of orifice";
parameter Real rho(unit="Kg/m^3")=999    "Density";  // This is taken from App.6 Pg1093
parameter Real Z(unit="m")=1.25          "Difference in manometer reading";
parameter Real mu(unit="kg/m.s")=0.001147"Viscosity of water at 15 C";

//===================
// Variable Section
Real deltaP(unit="N/m^2")  "Pressure difference";
Real So(unit="m^2")        "Area of orifice";
Real So1(unit="m^2")       "Area of orifice";
Real uo(unit="m/s")        "Velocity of water";
Real Do(unit="m")          "Orifice diameter";
Real Reo(unit="nil")       "Reynolds number";

//==================
//Equation  Section 
equation
deltaP= g*Z*rho*(13.6-1);
q= Co*So*sqrt((2*deltaP)/999)/sqrt((1-0.406^4));
(So/1)= ((3.14*Do^2)/4);
//sqrt(1-beta^4) is assumed as 1. 
//Here beta is assumed as 0.406. So, from this throat diameter is found out as 41mm.
So1= (3.14159* 0.041^2)/4;
uo= q/So1;
Reo = 0.041*uo*rho/mu; //Re is 375962. In txtbook its given as 376000

end Ex8_4_1;

model Ex8_4_2
//===================
// Parameter Section
// o denotes orifice.

parameter Real q(unit="m^3/s")=0.0139    "Flowrate ";
parameter Real g(unit="m/s^2")=9.80665   "Acceleration due to gravity";
parameter Real Co(unit="nil")=0.61       "Coefficient of orifice";
parameter Real rho(unit="Kg/m^3")=999    "Density";  // This is taken from App.6 Pg1093
parameter Real Z(unit="m")=1.25          "Difference in manometer reading";
parameter Real mu(unit="kg/m.s")=0.001147"Viscosity of water at 15 C";

//===================
// Variable Section
Real deltaP(unit="N/m^2")  "Pressure difference";
Real P(unit="kW")          "Power required";

//==================
//Equation  Section 
equation
deltaP= g*Z*rho*(13.6-1);
P= (0.81*q*deltaP)/1000; //From Fig 8.18 Pg230, for beta=0.406, the loss is 81%

end Ex8_4_2;

end Ex8_4;
