//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 9: Agitation and mixing of liquids
//Example  : 9.3 Pg 268
//Title: Agitated vessels.
//================================================================================================

model Ex9_3
//===================
// Parameter Section
parameter Real D(unit="ft")=6                    "Vessel diameter";
parameter Real D1(unit="ft")=2                   "Turbine diameter";
parameter Real n(unit="r/s")=1.333               "Rotating speed";
parameter Real rho(unit="lb/ft^3")=62.3          "Density";
parameter Real mu(unit="lb/ft.s")=6.6*10^(-4)    "Viscosity";
parameter Real nt(unit="nil")=36                 "Mixing factor. obtained from Fig 9.16 Pg 266";

//===================
// Variable Section
Real Re(unit="nil")   "Reynolds number";
Real t(unit="s")      "Time taken for neutralization to complete";

//==================
//Equation  Section 
equation
Re=n*D1^2*rho/mu; //Re is 503,000 in T.B. Here its 503308 due to roundoff error.
t=nt/n;

end Ex9_3;
