//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 9: Agitation and mixing of liquids
//Example  : 9.5 Pg 279
//Title: Dispersion operations.
//================================================================================================
package Ex9_5

model Ex9_5_1
//===================
// Parameter Section
parameter Real rho(unit="Kg/m^3")=760         "Density of cyclohexane";
parameter Real rho1(unit="Kg/m^3")=1000        "Density of water";
parameter Real D(unit="m")=0.3                "Vessel diameter";
parameter Real h(unit="m")=0.35               "Depth";
parameter Real sigma(unit="N/m")=46*10^(-3)   "Interfacial tension";
parameter Real rhomix(unit="Kg/m^3")=981      "Density of misture";
parameter Real D1(unit="m")=0.1               "Agitator diameter";
parameter Real D2(unit="m")=0.02              "Kenics helical diameter";
parameter Real n(unit="r/s")=6                "Speed of stirrer";
parameter Real mu(unit="Pa.s")=9*10^(-4)      "Viscosity of water at 25 C";
parameter Real Np(unit="nil")=5.75            "Constant. Obtained from Table 9.2 Pg 262";
parameter Real si(unit="nil")=0.08            "Liquid holdup in dispersion";
parameter Real f(unit="nil")=0.42             "Friction factor";
parameter Real C(unit="nil")=0.35             "Constant";
parameter Real v(unit="m/s")=1.2              "Velocity of the liquid mixture";
parameter Real L(unit="m")=0.6                "Length. its obtained by 20*0.03.";

//===================
// Variable Section
Real Re(unit="nil")           "Reynolds number";
Real V(unit="m^3")            "Volume";
Real P(unit="W")              "Power";
Real P1(unit="W/m^3")         "Power developed for the volume";
Real We(unit="nil")           "Weber number";
Real Ds(unit="m")             "Drop size";

//==================
//Equation  Section 
equation
Re= (D1^2*n*rhomix)/mu; //Re is 6.54*10^5 in T.B. Here its 65400.In T.B its wrongly printed.
P=Np*n^3*D1^5*rhomix;
V= 3.1415*D^2*(h/4);
P1=P/V;
We= (rho1*n^2*D1^3)/sigma;
(Ds/D1)= (0.058*(1+(5.4*si)))/We^0.6;

end Ex9_5_1;

model Ex9_5_2
//===================
// Parameter Section
parameter Real rho(unit="Kg/m^3")=760         "Density of cyclohexane";
parameter Real rho1(unit="Kg/m^3")=1000        "Density of water";
parameter Real D(unit="m")=0.3                "Vessel diameter";
parameter Real h(unit="m")=0.35               "Depth";
parameter Real sigma(unit="N/m")=46*10^(-3)   "Interfacial tension";
parameter Real rhomix(unit="Kg/m^3")=981      "Density of misture";
parameter Real D1(unit="m")=0.1               "Agitator diameter";
parameter Real D2(unit="m")=0.02              "Kenics helical diameter";
parameter Real n(unit="r/s")=6                "Speed of stirrer";
parameter Real mu(unit="Pa.s")=9*10^(-4)      "Viscosity of water at 25 C";
parameter Real Np(unit="nil")=5.75            "Constant. Obtained from Table 9.2 Pg 262";
parameter Real si(unit="nil")=0.08            "Liquid holdup in dispersion";
parameter Real f(unit="nil")=0.42             "Friction factor";
parameter Real C(unit="nil")=0.35             "Constant";
parameter Real v(unit="m/s")=1.2              "Velocity of the liquid mixture";
parameter Real L(unit="m")=0.6                "Length. its obtained by 20*0.03.";

//===================
// Variable Section
Real Ds1(unit="m")            "Drop size in a different mixer";
Real We1(unit="nil")          "Weber number for different mixer";
Real deltaP(unit="Pa")        "Pressure drop";
Real P3(unit="kW/m^3")         "Power developed for the volume in (b)";
Real V1(unit="m^3")           "Volume of the mixer";
Real P2(unit="W")             "Power developed";

//==================
//Equation  Section 
equation
We1= (rho1*v^2*D2)/sigma;
(Ds1/D2)=C/(We1^0.6 * f^0.4);
deltaP= (2*f*L*rhomix*v^2)/D2; //Its given 3.56*10^4.Here we get 35598.5 due to round off error.
P2= deltaP*(3.1415/4)*D2^2*v;
V1= (3.1415/4)*L*D2^2;
P3=(P2/V1)*10^(-3);//IN T.B its given 71.1KW. Here we get 71197.1 due to round off error.

end Ex9_5_2;

end Ex9_5;
