//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 9: Agitation and mixing of liquids
//Example  : 9.6 Pg 286
//Title: Agitator selection and scale up.
//================================================================================================


package Ex9_6
model Ex9_6_1
//===================
// Parameter Section
parameter Real P(unit="kW/^3")=0.4        "Power required";
parameter Real Re(unit="nil")=10000       "Reynolds number";
parameter Real D(unit="m")=0.3            "Vessel Diameter";
parameter Real D1(unit="m")=0.1           "Turbine impeller diameter";
parameter Real t(unit="s")=15             "Blending time";
parameter Real D2(unit="m")=1.8           "Another vessel diameter";

//===================
// Variable Section
Real X(unit="nil")                "Ratio of power inputs to different vessels";
Real P1(unit="kW/m^3")            "Power input required in different vessel";

//==================
//Equation  Section 
equation

//Since the Reynolds number is large, a different correlation is used. The mixing time factor nt is a constant, and since time t is assumed constant , speed will be same in both the vessels.
X= (D2/D)^2;   // X= (P6/D2^3)/(P1/D^3).
P1= X*P;
end Ex9_6_1;

model Ex9_6_2
//===================
// Parameter Section
parameter Real P(unit="kW/^3")=0.4        "Power required";
parameter Real Re(unit="nil")=10000       "Reynolds number";
parameter Real D(unit="m")=0.3            "Vessel Diameter";
parameter Real D1(unit="m")=0.1           "Turbine impeller diameter";
parameter Real t(unit="s")=15             "Blending time";
parameter Real D2(unit="m")=1.8           "Another vessel diameter";

//===================
// Variable Section
Real Y(unit="nil")                "Ratio of blending time";
Real t1(unit="s")                 "Blending time in new vessel";

//==================
//Equation  Section 
equation
//n6/n1= t6/t1. This is assumed.
Y=(D2/D)^(2/3); // Y= t6/t1.
t1=t*Y;

end Ex9_6_2;


end Ex9_6;
