//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 10: Heat transfer by conduction.
//Example  : 10.2 Pg 305
//Title: Steady state conduction.
//================================================================================================

package Ex10_2

model Ex10_2_1
//===================
// Parameter Section
parameter Real A(unit="ft^2")=1             "Area of the wall is assumed";
parameter Real T1(unit="F")=170             "Temperature on the inner side";
parameter Real T2(unit="F")=1400            "Temperature on the outer side";
parameter Real x1(unit="ft")=0.375          "Thickness of sil-o-cel brick";
parameter Real x2(unit="ft")=0.75           "Thickness of normal brick";
parameter Real Rc(unit="ft^2.h.F/Btu")=0.5  "Contact Resistance";
parameter Real K1(unit="Btu/ft.h.F")=0.08   "Thermal conductivity of sil-o-cel brick";
parameter Real K2(unit="Btu/ft.h.F")=0.8    "Thermal conductivity of normal brick";

//===================
// Variable Section
Real q1(unit="Btu/h")         "Rate of heat flow";
Real Ra(unit="nil")           "Thermal resistance of sil-o-cel brick";
Real Rb(unit="nil")           "Thermal resistance of normal brick";
Real Rt(unit="nil")           "Total Thermal resistance";
Real deltaT(unit="F")         "Temperature difference";


//==================
//Equation  Section 
equation
deltaT=T2-T1;
Ra= x1/K1;
Rb=x2/K2;
Rt=Ra+Rb;
q1=deltaT/Rt;

end Ex10_2_1;

model Ex10_2_2
//===================
// Parameter Section
parameter Real A(unit="ft^2")=1             "Area of the wall is assumed";
parameter Real T1(unit="F")=170             "Temperature on the inner side";
parameter Real T2(unit="F")=1400            "Temperature on the outer side";
parameter Real x1(unit="ft")=0.375          "Thickness of sil-o-cel brick";
parameter Real x2(unit="ft")=0.75           "Thickness of normal brick";
parameter Real Rc(unit="ft^2.h.F/Btu")=0.5  "Contact Resistance";
parameter Real K1(unit="Btu/ft.h.F")=0.08   "Thermal conductivity of sil-o-cel brick";
parameter Real K2(unit="Btu/ft.h.F")=0.8    "Thermal conductivity of normal brick";

//===================
// Variable Section
Real deltaTA(unit="F")        "Temperature difference";
Real Ra(unit="nil")           "Thermal resistance of sil-o-cel brick";
Real Rt(unit="nil")           "Total Thermal resistance";
Real deltaT(unit="F")         "Temperature difference";
Real Rb(unit="nil")           "Thermal resistance of normal brick";

//==================
//Equation  Section 
equation
deltaT=T2-T1;
Ra= x1/K1;
Rb=x2/K2;
Rt=Ra+Rb;
deltaTA= Ra*(deltaT/Rt);

end Ex10_2_2;

model Ex10_2_3
//===================
// Parameter Section
parameter Real A(unit="ft^2")=1             "Area of the wall is assumed";
parameter Real T1(unit="F")=170             "Temperature on the inner side";
parameter Real T2(unit="F")=1400            "Temperature on the outer side";
parameter Real x1(unit="ft")=0.375          "Thickness of sil-o-cel brick";
parameter Real x2(unit="ft")=0.75           "Thickness of normal brick";
parameter Real Rc(unit="ft^2.h.F/Btu")=0.5  "Contact Resistance";
parameter Real K1(unit="Btu/ft.h.F")=0.08   "Thermal conductivity of sil-o-cel brick";
parameter Real K2(unit="Btu/ft.h.F")=0.8    "Thermal conductivity of normal brick";

//===================
// Variable Section
Real Rt1(unit="nil")          "Total Thermal resistance including contact resistance";
Real q2(unit="Btu/h")         "Rate of heat flow";
Real Ra(unit="nil")           "Thermal resistance of sil-o-cel brick";
Real Rb(unit="nil")           "Thermal resistance of normal brick";
Real Rt(unit="nil")           "Total Thermal resistance";
Real deltaT(unit="F")         "Temperature difference";

//==================
//Equation  Section 
equation
deltaT=T2-T1;
Ra= x1/K1;
Rb=x2/K2;
Rt=Ra+Rb;
Rt1=Rt+Rc;
q2=deltaT/Rt1;


end Ex10_2_3;


end Ex10_2;
