//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 10: Heat transfer by conduction.
//Example  : 10.4 Pg 312
//Title: Unsteady state conduction.
//============================================================================================
package Ex10_4
model Ex10_4_1
extends Modelica.Constants;

//===================
// Parameter Section
parameter Real Ta(unit="C")=90             "Temperature at the beginning";
parameter Real Ts(unit="C")=30             "Surface Temperature";
parameter Real rho(unit="Kg/m^3")=1050     "Density of solid";
parameter Real Cp(unit="J/Kg.K")=800       "Specific heat of solid";
parameter Real k(unit="W/m.K")=1.8         "Thermal conductivity of solid ";
parameter Real tT(unit="s")=180            "Time mentioned in problem";
parameter Real a1(unit="nil")=2.467        "Constant"; // a1= (pi/2)^2

//===================
// Variable Section
Real Fo(unit="nil")         "Fourier number";
Real s(unit="m")            "Half thickness of slab";
Real alpha(unit="m^2/s")    "Thermal diffusivity";
Real T(unit="C")            "Temperature at the center";
Real T1(unit="C")           "Temperature at the halfway from the surface";

// In book same variable is used. T1 is used to differentiate from T.

//==================
//Equation  Section 
equation
alpha= k/(rho*Cp);
s=0.08/2;  //The slab is 8cm thick. 
Fo= (alpha*tT)/(s^2);
(Ts-T)= (Ts-Ta)* (4/pi)*((exp(-0.594)*sin(pi/2)) + ((1/3)*exp(-9*0.594)*sin(3*pi/2)));
(Ts-T1)= (Ts-Ta)* (4/pi)*((exp(-0.594)*sin(pi*0.5/2)) + ((1/3)*exp(-9*0.594)*sin(3*pi*0.5/2)));

end Ex10_4_1;

model Ex10_4_2
extends Modelica.Constants;

//===================
// Parameter Section
parameter Real Ta(unit="C")=90             "Temperature at the beginning";
parameter Real Ts(unit="C")=30             "Surface Temperature";
parameter Real rho(unit="Kg/m^3")=1050     "Density of solid";
parameter Real Cp(unit="J/Kg.K")=800       "Specific heat of solid";
parameter Real k(unit="W/m.K")=1.8         "Thermal conductivity of solid ";
parameter Real tT(unit="s")=180            "Time mentioned in problem";
parameter Real a1(unit="nil")=2.467        "Constant"; // a1= (pi/2)^2

//===================
// Variable Section
Real Tb(unit="C")           "Average temperature after 3 minutes";

//==================
//Equation  Section 
equation
(Ts-Tb)/(Ts-Ta)=0.45; 
//0.45 is obtained from Fig 10.5 Pg311 for correspoding Fo.

end Ex10_4_2;


end Ex10_4;
