//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 12: Heat transfer to fluids without phase change.
//Example  : 12.1 Pg 361
//Title: Heat transfer by forced convection in turbulent flow. 
//================================================================================================

model Ex12_1
//Table 12.1 is used for certain values.
//===================
// Parameter Section
parameter Real di(unit="in")=0.62            "Diameter of tubes";
parameter Real do(unit="in")=0.75            "Diameter of tubes";

//===================
// Variable Section
Real deltaTi(unit="F")     "Temperature difference";
Real Tw(unit="F")          "Wall temperature";

//==================
//Equation  Section 
equation
deltaTi=((1/700)/((1/700)+(di/(do*500))))*(230-80);
Tw=deltaTi+80;

end Ex12_1;
