//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 12: Heat transfer to fluids without phase change.
//Example  : 12.1 Pg 361
//Title: Heat transfer by forced convection in turbulent flow. 
//================================================================================================

model Ex12_2
extends Modelica.Constants;

//From table 12.2 certain values are taken.
//===================
// Parameter Section
parameter Real dit(unit="ft")=0.0621    "Diameter of tubes";
parameter Real dot(unit="ft")=0.0729    "Diameter of tubes";
parameter Real dij(unit="ft")=0.1342    "Diameter of tubes";
parameter Real T1(unit="F")=141         "Initial temperature";
parameter Real T2(unit="F")=79          "Final temperature";
parameter Real V(unit="ft/s")=5         "Linear velocity";
parameter Real muwb(unit="lb/ft.h")=1.45 "Viscosity of benzene at Tw";
parameter Real muww(unit="lb/ft.h")=2.06 "Viscosity of water at Tw";

//===================
// Variable Section
Real rH(unit="ft")          "Hydraulic radius";
Real De(unit="ft")          "Equivalent diameter";
Real mb(unit="lb/s")        "Flow rate of benzene";
Real q(unit="Btu/s")        "Heat flow";
Real mw(unit="lb/s")        "Flowrate of water";
Real Vw(unit="ft/s")        "Velocity of water";
Real Re1(unit="nil")        "Reynolds number of benzene";
Real Pr1(unit="nil")        "Prandtl number";
Real Re2(unit="nil")        "Reynolds number of water";
Real Pr2(unit="nil")        "Prandtl number";
Real hi(unit="Btu/ft^2.h.F")"Heat transfer coefficient"; 
Real ho(unit="Btu/ft^2.h.F")"Heat transfer coefficient";
Real deltaTi(unit="F")      "Temperature difference";
Real deltaTi1(unit="F")     "Temperature difference";
Real Tw(unit="F")           "Wall temperature";
Real Tw1(unit="F")          "Wall temperature";
Real fib(unit="nil")        "Viscosity correlation factor";
Real fiw(unit="nil")        "Viscosity correlation factor";
Real hi1(unit="Btu/ft^2.h.F")"Corrected Heat transfer coefficient"; 
Real ho1(unit="Btu/ft^2.h.F")"Corrected Heat transfer coefficient";
Real Uo(unit="Btu/h.ft^2.F") "overall coefficient";


//==================
//Equation  Section 
equation
rH=(pi/4)*(dij^2-dot^2)/(pi*(dij+dot));
De=4*rH;
mb=V*53.1*0.00303; //0.00303 is Cross sectional area.
q=mb*0.435*(T1-T2);
mw=q/(1*(75-65));
Vw=mw/(0.00997*62.3);
Re1=(dit*V*53.1*3600)/1.16;
//In T.B it given 5.12*10^4 Here we get 51168.3
Pr1=(0.435*1.15)/0.089;
Re2=(De*Vw*62.3*3600)/2.34;
//In T.B it given 2.05*10^4 Here we get20523
Pr2=(1*2.34)/0.346;
hi=(0.023*V*3600*53.1*0.435)/((Re1^0.2)*(Pr1)^(2/3));
ho=(0.023*Vw*3600*62.3*1)/((Re2^0.2)*(Pr2)^(2/3));
deltaTi=((1/344)/((1/344)+dit/(dot*ho)))*(110-70);
Tw=110-deltaTi;
fib=(1.16/muwb)^0.14;
fiw=(2.34/muww)^0.14;
hi1=hi*fib;
ho1=ho*fiw;
deltaTi1=((1/333)/((1/333)+dit/(dot*ho1)))*(110-70);
Tw1=110-deltaTi1;
(1/Uo)=(dot/(333*dit))+(1/ho1);

end Ex12_2;
