//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 15: Heat Exchange Equipment
//Example  : 15.1 Pg 448
//Title: Shell and tube heat exchangers. 
//================================================================================================

model Ex15_1
//===================
// Parameter Section

//The figure for this problem is Fig 15.5a Pg446
 
parameter Real Tca(unit="C")=70        "Temperature on cold side";
parameter Real Tcb(unit="C")=120       "Temperature on cold side";
parameter Real Tha(unit="C")=240       "Temperature on hot side";
parameter Real Thb(unit="C")=120       "Temperature on hot side";

//===================
// Variable Section
Real FG(unit="nil")           "Correctness factor";
Real etaH(unit="nil")         "Heating effectiveness";
Real Z(unit="nil")            "Ratio of temperature ranges";
Real deltaT1(unit="C")        "Temperature difference at shell inlet";
Real deltaT2(unit="C")        "Temperature difference at shell outlet";
Real deltaTL(unit="C")        "log mean Temperature difference";
Real deltaTbar(unit="C")      "Correct Mean temperature difference";

//==================
//Equation  Section 
equation
etaH= (Tcb-Tca)/(Tha-Tca);
Z= (Tha-Thb)/(Tcb-Tca);
FG= (2.6*log((1-etaH)/(1-(Z*etaH))))/(1.4*log((2-etaH*(3.4-2.6))/(2-etaH*(3.4+2.6))));
deltaT1=(Tha-Tcb);
deltaT2=(Thb-Tca);
deltaTL= (deltaT1-deltaT2)/log(deltaT1/deltaT2);
deltaTbar=0.81*deltaTL;

end Ex15_1;
