//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 15: Heat Exchange Equipment
//Example  : 15.3 Pg 450
//Title: Shell and tube heat exchangers. 
//================================================================================================

model Ex15_3

extends Modelica.Constants;

//===================
// Parameter Section
parameter Real Ds(unit="ft")=2.9167       "Inside diameter";
parameter Real f(unit="nil")=0.1955       "Fanning friction factor";
parameter Real Do(unit="ft")=0.0625       "Outside diameter";
parameter Real p(unit="ft")=0.0833        "Center to center distance between tubes";
parameter Real P(unit="ft")=1             "Baffle pitch";
parameter Real mu1(unit="cP")=0.7         "Viscosity taken from App.9 at 70F";
parameter Real mu2(unit="cP")=0.38        "Viscosity taken from App.9 at 140F";
parameter Real Cp(unit="Btu/lb.F")=0.41   "Specific heat from App.15";
parameter Real k(unit="Btu/ft.h.F")=0.092 "Thermal conductivity from App.13";

//===================
// Variable Section 
Real Sc(unit="ft^2")        "Area of crossflow";
Real Nb(unit="nil")         "Number of tubes";
Real Sb(unit="ft^2")        "Area for flow in baffle";
Real Gc(unit="lb/ft^2.h")   "Mass velocity";        
Real Gb(unit="lb/ft^2.h")   "Mass velocity"; 
Real Ge(unit="lb/ft^2.h")   "Mass velocity";
Real ho(unit="Btu/ft^2.h.F")"Heat transfer coefficient for outside of tube";

//==================
//Equation  Section 
equation 
Sc= Ds*1*(1-(Do/p));
Nb=f*828;  // Nb is taken as 161 as it should be a whole number.
Sb= f*((pi*Ds^2)/4)-(161*((pi*Do^2)/4));
Gc=100000/Sc;
Gb=100000/Sb;
Ge=sqrt(Gb*Gc);
ho= (k/Do)*(0.2*((Do*Ge)/(mu1*2.42))^(0.6)* ((Cp*mu1*2.42)/k)^(0.33)* (mu1/mu2)^(0.14));

end Ex15_3;
