//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 15: Heat Exchange Equipment
//Example  : 15.5 Pg 457
//Title: Plate Type exchangers. 
//================================================================================================

package Ex15_5
model Ex15_5_1
//===================
// Parameter Section
parameter Real Tca(unit="F")=41           "Temperature on cold side";
parameter Real Tcb(unit="F")=57           "Temperature on cold side";
parameter Real Tha(unit="F")=60           "Temperature on hot side";
parameter Real Thb(unit="F")=44           "Temperature on hot side";
parameter Real k(unit="W/m.K")=0.576      "Thermal conductivity at 50F, from App.6 ";
parameter Real Cp(unit="J/Kg.K")=4184     "Specific heat";
parameter Real mu(unit="cP")=0.131        "Viscosity ";
parameter Real De(unit="m")=6*10^(-3)     "Diameter of tubes";
parameter Real rho(unit="Kg/m^3")=1000    "Density";
parameter Real km(unit="W/m.K")=16.3      "Thermal conductivity for 0.7mm stainless steel";
parameter Real Q(unit="gal/min")=4000     "Flowrate";
parameter Real u(unit="m/s")=0.5          "Water velocity";


//===================
// Variable Section
Real Re(unit="nil")                  "Reynolds number";
Real Pr(unit="nil")                  "Prandtl number";
Real hi(unit="W/m^2.K")              "Inner wall coefficient ";
Real hw(unit="W/m.K")                "Wall coefficient ";
Real Nu(unit="nil")                  "Nusselt number";
Real U(unit="W/m^2.K")               "Overall heat transfer coefficient";

//==================
//Equation  Section 
equation 
Re=(De*rho*u)/(1.31*10^(-3));
Pr= Cp*(1.31*10^(-3))/k;
Nu=0.37*(Re)^0.67*(Pr)^0.33;
hi=(Nu*k)/De; //InT.B its given as 1.33*10^4/ Here we get 13318 due to round off error
hw=km/(7*10^(-4));
(1/U)= (2/hi)+(1/hw);//In T.B its given as 5.17*10^3. Here we get 5178.


end Ex15_5_1;

model Ex15_5_2
//===================
// Parameter Section
parameter Real Tca(unit="F")=41           "Temperature on cold side";
parameter Real Tcb(unit="F")=57           "Temperature on cold side";
parameter Real Tha(unit="F")=60           "Temperature on hot side";
parameter Real Thb(unit="F")=44           "Temperature on hot side";
parameter Real k(unit="W/m.K")=0.576      "Thermal conductivity at 50F, from App.6 ";
parameter Real Cp(unit="J/Kg.K")=4184     "Specific heat";
parameter Real mu(unit="cP")=0.131        "Viscosity ";
parameter Real De(unit="m")=6*10^(-3)     "Diameter of tubes";
parameter Real rho(unit="Kg/m^3")=1000    "Density";
parameter Real km(unit="W/m.K")=16.3      "Thermal conductivity for 0.7mm stainless steel";
parameter Real Q(unit="gal/min")=4000     "Flowrate";
parameter Real u(unit="m/s")=0.5          "Water velocity";


//===================
// Variable Section
Real deltaT1(unit="F")               "Temperature difference";
Real deltaT2(unit="F")               "Temperature difference";
Real Re(unit="nil")                  "Reynolds number";
Real Pr(unit="nil")                  "Prandtl number";
Real hi(unit="W/m^2.K")              "Inner wall coefficient ";
Real hw(unit="W/m.K")                "Wall coefficient ";
Real Nu(unit="nil")                  "Nusselt number";
Real U(unit="W/m^2.K")               "Overall heat transfer coefficient";
Real L(unit="m")                     "Height of plate";
Real L1(unit="m")                    "Revised Height of plate";

//==================
//Equation  Section 
equation 
Re=(De*rho*u)/(1.31*10^(-3));
Pr= Cp*(1.31*10^(-3))/k;
Nu=0.37*(Re)^0.67*(Pr)^0.33;
hi=(Nu*k)/De; //InT.B its given as 1.33*10^4/ Here we get 13318 due to round off error
hw=km/(7*10^(-4));
(1/U)= (2/hi)+(1/hw);//In T.B its given as 5.17*10^3. Here we get 5178.
deltaT1= Tha-Thb;
deltaT2=Tcb-Tca;
L= ((1.5*Cp)/(2*0.9*U))*(16/3);
L1=L/2;

end Ex15_5_2;

model Ex15_5_3
//===================
// Parameter Section
parameter Real Tca(unit="F")=41           "Temperature on cold side";
parameter Real Tcb(unit="F")=57           "Temperature on cold side";
parameter Real Tha(unit="F")=60           "Temperature on hot side";
parameter Real Thb(unit="F")=44           "Temperature on hot side";
parameter Real k(unit="W/m.K")=0.576      "Thermal conductivity at 50F, from App.6 ";
parameter Real Cp(unit="J/Kg.K")=4184     "Specific heat";
parameter Real mu(unit="cP")=0.131        "Viscosity ";
parameter Real De(unit="m")=6*10^(-3)     "Diameter of tubes";
parameter Real rho(unit="Kg/m^3")=1000    "Density";
parameter Real km(unit="W/m.K")=16.3      "Thermal conductivity for 0.7mm stainless steel";
parameter Real Q(unit="gal/min")=4000     "Flowrate";
parameter Real u(unit="m/s")=0.5          "Water velocity";


//===================
// Variable Section
Real f(unit="nil")                   "Friction factor";
Real deltaP(unit="N/m^2")            "Pressure drop ";

//==================
//Equation  Section 
equation
f=2.5/(2290)^0.3;
deltaP=((2*f*u^2*rho*3.6)/De);
//In T.B its given 7.35*10^4.Here we get 73639.5.

end Ex15_5_3;

model Ex15_5_4
//===================
// Parameter Section
parameter Real Tca(unit="F")=41           "Temperature on cold side";
parameter Real Tcb(unit="F")=57           "Temperature on cold side";
parameter Real Tha(unit="F")=60           "Temperature on hot side";
parameter Real Thb(unit="F")=44           "Temperature on hot side";
parameter Real k(unit="W/m.K")=0.576      "Thermal conductivity at 50F, from App.6 ";
parameter Real Cp(unit="J/Kg.K")=4184     "Specific heat";
parameter Real mu(unit="cP")=0.131        "Viscosity ";
parameter Real De(unit="m")=6*10^(-3)     "Diameter of tubes";
parameter Real rho(unit="Kg/m^3")=1000    "Density";
parameter Real km(unit="W/m.K")=16.3      "Thermal conductivity for 0.7mm stainless steel";
parameter Real Q(unit="gal/min")=4000     "Flowrate";
parameter Real u(unit="m/s")=0.5          "Water velocity";


//===================
// Variable Section
Real mc(unit="m^3/s")                "Flowrate of cold fluid";
Real n(unit="nil")                   "Number of channels";
Real n1(unit="nil")                  "Total number of channels";
Real n2(unit="nil")                  "Number of plates";
Real n3(unit="nil")                  "Total Number of plates";

//==================
//Equation  Section 
equation
mc= Q/(264.7*60);
n=mc/(1.5*10^(-3)); //The textook value is 147 and its wrong. Its printing mistake.
n1=2*n;
n2=n1+1;
n3=2*n2;

end Ex15_5_4;

end Ex15_5;
