//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 17: Principles of diffusion and mass transfer between phases
//Example  : 17.2 Pg 537
//Title: Prediction of diffusivities. 
//================================================================================================

model Ex17_2

// The force constant values from App.19 are given in a table Pg537.

//===================
// Parameter Section
parameter Real T(unit="C")=100              "Temperature";
parameter Real P(unit="atm")=2              "Pressure";
parameter Real DAB1(unit="cm^2/s")=0.0772   
"Diffisuvitiy at std temperature and pressure and it is taken from App.18";

parameter Real X(unit="nil")=1.062          
"A variable is used to represent Collision integral and it is taken from App.19";

//===================
// Variable Section
Real sigmaAB(unit="nil")        "Effective Collision diameter";
Real epsilonAB(unit="nil")      "Lennard jones constant";
Real x(unit="nil")              "Variale used to represent kT/epsilon";
Real DAB(unit="cm^2/s")         "Diffisuvitiy"; 


//==================
//Equation  Section 
equation
sigmaAB= (5.349+3.711)/2;
epsilonAB= sqrt(412.3*78.5);
x=373/epsilonAB;
DAB= (0.001858*(373)^(1.5)*((78.1+29)/(78.1*29))^0.5)/(2*4.53^2*X);

end Ex17_2;
