//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 17: Principles of diffusion and mass transfer between phases
//Example  : 17.5 Pg 553
//Title: Mass transfer theories. 
//================================================================================================

package Ex17_5
model Ex17_5_1
//===================
// Parameter Section
parameter Real d(unit="inch")=2         "Diameter";
parameter Real Re(unit="nil")=10000     "Reynolds number";
parameter Real T(unit="C")=40           "Temperature";
parameter Real mu(unit="cP")=0.0186     "Viscosity taken from App.8";
parameter Real Dv1(unit="cm^2/s")=0.288 "Diffusivity";
parameter Real Dv2(unit="cm^2/s")=0.145 "Diffusivity";

//===================
// Variable Section
Real rho(unit="g/cm^3")         "Density";
Real x(unit="cm^2/s")           "Variable to represent mu/rho";
Real Sc(unit="nil")             "Schmidt number";
Real Sh(unit="nil")             "Sherwood number";
Real BT1(unit="inch")           "Effective thickness";

//==================
//Equation  Section 
equation
rho= (29/22410)*(273/313);
x=(1.86*10^(-4))/rho;
Sc=x/Dv1;
Sh=0.023*Re^0.81*Sc^0.44;
BT1=d/Sh;

end Ex17_5_1;

model Ex17_5_2
//===================
// Parameter Section
parameter Real d(unit="inch")=2         "Diameter";
parameter Real Re(unit="nil")=10000     "Reynolds number";
parameter Real T(unit="C")=40           "Temperature";
parameter Real mu(unit="cP")=0.0186     "Viscosity taken from App.8";
parameter Real Dv1(unit="cm^2/s")=0.288 "Diffusivity";
parameter Real Dv2(unit="cm^2/s")=0.145 "Diffusivity";

//===================
// Variable Section
Real Sc1(unit="nil")            "Schmidt number";
Real Sh1(unit="nil")            "Sherwood number";
Real BT2(unit="inch")           "Effective thickness";
Real rho(unit="g/cm^3")         "Density";
Real x(unit="cm^2/s")           "Variable to represent mu/rho";

//==================
//Equation  Section 
equation
rho= (29/22410)*(273/313);
x=(1.86*10^(-4))/rho;
Sc1=x/Dv2;
Sh1=0.023*Re^0.81*Sc1^0.44;
BT2=d/Sh1;

end Ex17_5_2;

end Ex17_5;
