//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 18: Gas Absorption.
//Example  : 18.2 Pg 575
//Title: Packings and packed tower design. 
//================================================================================================

model Ex18_2

// This problem is same as 18_1 except that the packing is changed.

//===================
// Parameter Section
parameter Real x(unit="nil")=1.25            "Varaible to represent ratio of liquid flow to gas flow";
parameter Real rhox(unit="lb/ft^3")=62.3     "Density";
parameter Real rhoy(unit="lb/ft^3")=0.07465  "Density";
parameter Real uo(unit="ft/s")=0.11          "Superficial gas velocity";

//===================
// Variable Section
Real y(unit="nil")                   "Variale to represent pressure drop correlation";
Real uof(unit="ft/s")                "Superficial gas velocity at flooding";
Real uo1(unit="ft/s")                "Superficial gas velocity at 60% flooding";
Real G(unit="lb/ft^2.h")             "Mass velocity ";
Real z(unit="nil")                   "Variale to represent increase in mass velocity"; 

//==================
//Equation  Section 
equation
y=x*(rhoy/rhox)^0.5;
uof=uo*sqrt((rhox-rhoy)/rhoy)*3.2808; 
//The answer is given in m/s in Textook.It is converted here to ft/s
uo1=uof*0.6;
G=uo1*rhoy*3600;
z=(G/1000)-1;

end Ex18_2;
