//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 18: Gas Absorption.
//Example  : 18.3 Pg 584
//Title: Principles of absorption. 
//================================================================================================

package Ex18_3

model Ex18_3_1

//Isothermal operation is assumed for this problem
//===================
// Parameter Section
parameter Real kxa(unit="mol/h.ft^3.unitmolfraction")=60 
"Individual mass transfer coefficient in liquid phase";
parameter Real kya(unit="mol/h.ft^3.unitmolfraction")=15 
"Individual mass transfer coefficient in gas phase";
parameter Real xa(unit="nil")=0        "Mole fraction in liquid phase.Its assumed";
parameter Real ya(unit="nil")=0.0003   "Mole fraction of A in gas outlet";
parameter Real yb(unit="nil")=0.03     "Mole fraction of A in gas inlet";
parameter Real L(unit="mol/h.ft^2")=20 "Liquid flow rate";     
parameter Real V(unit="mol/h.ft^2")=20 "Gas flow rate";   

//===================
// Variable Section
Real ybstar(unit="nil")     "Mole fraction of B";
Real xb(unit="nil")         "Mole fraction of A in liquid outlet";
Real z(unit="nil")          "Variable to represent (yb-ybstar) ";
Real z1(unit="nil")         "Variable to represent (ya-yastar) ";
Real deltayL(unit="nil")    "Logarithmic value of mole fraction";
Real Kya(unit="mol/h.ft^3") "Overall mass transfer coefficient in gas phase";
Real Hoy(unit="ft")         "Height of transfer units";
Real Noy(unit="nil")        "Number of transfer units";
Real ZT(unit="ft")          "vertical distance";

//==================
//Equation  Section 
equation
xb=(L*0.99*yb)/100;
ybstar=3.1*xb; //The equilibirium relation is ystar=3.1*x.
z=yb-ybstar;
z1=ya-0; //yastar=0.
deltayL= (z-z1)/log(z/z1);
Noy= (0.03*0.99)/deltayL;
(1/Kya)=(1/kya)+(3.1/kxa); //H=3.1
Hoy= V/Kya;
ZT=Hoy*Noy;


end Ex18_3_1;

model Ex18_3_2

//Isothermal operation is assumed for this problem
//===================
// Parameter Section
parameter Real kxa(unit="mol/h.ft^3.unitmolfraction")=60 
"Individual mass transfer coefficient in liquid phase";
parameter Real kya(unit="mol/h.ft^3.unitmolfraction")=15 
"Individual mass transfer coefficient in gas phase";
parameter Real xa(unit="nil")=0        "Mole fraction in liquid phase.Its assumed";
parameter Real ya(unit="nil")=0.0003   "Mole fraction of A in gas outlet";
parameter Real yb(unit="nil")=0.03     "Mole fraction of A in gas inlet";
parameter Real L(unit="mol/h.ft^2")=20 "Liquid flow rate";     
parameter Real V(unit="mol/h.ft^2")=20 "Gas flow rate";   

//===================
// Variable Section
Real xstar(unit="nil")       "Equilibirium Mole fraction of A at the bottom ";
Real deltax(unit="nil")      "Difference in mole fraction";
Real deltax1(unit="nil")      "Difference in mole fraction";
Real xstar1(unit="nil")      "Equilibirium Mole fraction of A at the top ";
Real deltaxL(unit="nil")     "Logarithmic value of mole fraction";
Real Kxa(unit="mol/h.ft^3") "Overall mass transfer coefficient in liquid phase";
Real Hox(unit="ft")          "Height of transfer units";
Real Nox(unit="nil")         "Number of transfer units";
Real ZT(unit="ft")           "vertical distance";

//==================
//Equation  Section 
equation
xstar= yb/3.1;
deltax= xstar-0.00594;
xstar1= ya/3.1;
deltax1=xstar1-0;
deltaxL= (deltax-deltax1)/log(deltax/deltax1);
Nox= 0.00594/deltaxL;
(1/Kxa)=(1/kxa)+(1/(3.1*kya));
Hox=100/Kxa;
ZT=Hox*Nox;

end Ex18_3_2;


end Ex18_3;
