//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 18: Gas Absorption.
//Example  : 18.5 Pg 592
//Title: Principles of absorption. 
//================================================================================================

model Ex18_5

//This proble is done for the air rate is 1.5 times the minimum value. In text book the question is for 1.5-5 times. The rest are not done. The answers are given directly. So all other cases are not done here.

//===================
// Parameter Section
parameter Real Ca(unit="ppm")=6              "Concentration at inlet";
parameter Real Cbstar(unit="ppm")=0          "Concentration at equilibirium. Its assumed";
parameter Real Cb(unit="ppm")=0.0045         "Concentration at outlet";
parameter Real P(unit="atm")=1               "Pressure";
parameter Real H(unit="m^3")=0.0075          "Henry's law coefficient";
parameter Real Hox(unit="ft")=3              "Height of transfer units"; 

//===================
// Variable Section
Real m(unit="nil")                "Slope of equilibirium curve";
Real xa(unit="nil")               "Mole fraction in liquid phase";
Real xastar(unit="nil")           "Mole fraction at equilibirium";
Real ya(unit="nil")               "Mole fraction of A in gas outlet";
Real ya1(unit="nil")              "Mole fraction of A in gas outlet";
Real VTCE(unit="mol")             "Amount of TCE removed"; 
Real V(unit="mol")                "Amount of gas leaving";
Real Fmin(unit="std m^3")         "Minimum value of gas fed";
Real X(unit="Kg air/Kg water")    "Variable to represent ratio of mass velocity";
Real Castar(unit="ppm")           "Concentration at equilibirium";
Real deltaCa(unit="nil")          "Concentration difference";
Real deltaCb(unit="nil")          "Concentration difference";
Real deltaCL(unit="ppm")          "Logarithmic concentration difference";
Real Nox(unit="nil")              "Number of transfer units";

//==================
//Equation  Section 
equation
m= H*10^6/18; //1m^3 of liquid weighs 10^6 g and nol.wt of H20 is 18.
xa=((Ca*10^(-6))*18)/131.4;
ya=m*xa;
VTCE= 10^6*((Ca*10^(-6))-(Cb*10^(-6)))/131.4;
V=VTCE/ya;
Fmin=V*0.0224; //1gmol=0.0224 std m^3.
X=(Fmin*1.295)/1000;
ya1=ya/1.5;
xastar=ya1/m;
Castar=xastar*(131.4/18)/(10^(-6));
deltaCa=Ca-Castar;
deltaCb=Cb-Cbstar;
deltaCL= (deltaCa-deltaCb)/log(deltaCa/deltaCb);
Nox=(Ca-Cb)/deltaCL;

// The other conditions are not solved in textook. The final answer is given in a Table. Pg593.


end Ex18_5;
