//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 19: Humidification operations.
//Example  : 19.1 Pg 619
//Title: Definitions. 
//================================================================================================

model Ex19_1

//A table is given wehre the total nuber of moles, Specific heat of each component and n*Cp is given,

//===================
// Parameter Section
parameter Real P(unit="atm")=1               "Pressure";
parameter Real T(unit="F")=320               "temperature of flue gas";
parameter Real Ts(unit="F")=120              "temperature of steam,its a guessed value";
parameter Real Ts1(unit="F")=126             "temperature of steam,its a guessed value";
parameter Real nCp(unit="nil")=744.75        "Given in table Pg619";

//===================
// Variable Section
Real lamdas(unit="Btu/lb.mol")               "latent heat of vapourisation";
Real lamdas1(unit="Btu/lb.mol")              "latent heat of vapourisation";
Real deltaT(unit="F")                        "Teperature difference";
Real deltaT1(unit="F")                       "Teperature difference";
Real z(unit="nil")                           "Number of moles of water evaporated";
Real z1(unit="nil")                          "Total moles of water evaporated";    
Real y(unit="nil")                           "Mole fraction of water in exit gas";
Real z2(unit="nil")                          "Number of moles of water evaporated for another case";
Real z3(unit="nil")                          "Total moles of water evaporated for another case"; 
Real y1(unit="nil")                          "Mole fraction of water in exit gas";


//==================
//Equation  Section 
equation
lamdas=1025.25*18; //From APp.7 at 120F Pg.1094
deltaT=(T-Ts);
(nCp*deltaT)=(z*(lamdas+720));
z1=z+7;
y=z1/107.77;   //basis is 100 mole of gas. 
deltaT1=T-Ts1;
//From Fig19.1 for y=0.137 ts=126.
lamdas1=1022.1*18;
(nCp*deltaT1)=z2*(lamdas1+(18*(Ts1-80)));
z3=z2+7;
y1=z3/107.51;

//The (b) part is same as the (a) part. The answers obtained are same so it is not done.

end Ex19_1;
