//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 19: Humidification operations.
//Example  : 19.3 Pg 637
//Title: Cooling towers. 
//================================================================================================

package Ex19_3
model Ex19_3_1
//The problem is not solved, the answer is written directly, so the coding is done for what it is solved in textbook.
 
//===================
// Parameter Section
parameter Real Gx(unit="lb/h.ft^2")=2200            "mass velocity in liquid stream";
parameter Real Gy(unit="lb/h.ft^2")=2000            "mass velocity in gas stream";
parameter Real hb(unit="lb water/lb air")=0.017     "Humidity at bottom";//taken from Fig19.2 Pg621
parameter Real hb1(unit="lb water/lb air")=0.009    "Humidity at bottom";//taken from Fig19.2 Pg621
parameter Real hr(unit="%")=55                      "Relative Humidity";//taken from Fig19.2 Pg621
parameter Real cs(unit="Btu/lb.F")=0.248            "Humid heat";//taken from Fig19.2 Pg621
parameter Real cs1(unit="Btu/lb.F")=0.244           "Humid heat";//taken from Fig19.2 Pg621
parameter Real Ty(unit="F")=70                      "Temperature of gas";
parameter Real Tw(unit="F")=60                      "Wet bulb Temperature";
parameter Real TW1(unit="F")=105                    "Inlet water Temperature";
parameter Real TW2(unit="F")=85                     "Outlet water Temperature";

//===================
// Variable Section
Real Hb(unit="Btu/lb")        "Enthalpy";
Real Ha(unit="Btu/lb")        "Enthalpy";
Real Hoy(unit="ft")           "Height of transfer units";

//==================
//Equation  Section 
equation
Hb=cs*(90-32)+(1075*hb);
Gx*1*(TW1-TW2)=Gy*(Ha-Hb);
Hoy=4/1.82; //1.82 is Noy.

end Ex19_3_1;

model Ex19_3_2
//The problem is not solved, the answer is written directly, so the coding is done for what it is solved in textbook.
 
//===================
// Parameter Section
parameter Real Gx(unit="lb/h.ft^2")=2200            "mass velocity in liquid stream";
parameter Real Gy(unit="lb/h.ft^2")=2000            "mass velocity in gas stream";
parameter Real hb(unit="lb water/lb air")=0.017     "Humidity at bottom";//taken from Fig19.2 Pg621
parameter Real hb1(unit="lb water/lb air")=0.009    "Humidity at bottom";//taken from Fig19.2 Pg621
parameter Real hr(unit="%")=55                      "Relative Humidity";//taken from Fig19.2 Pg621
parameter Real cs(unit="Btu/lb.F")=0.248            "Humid heat";//taken from Fig19.2 Pg621
parameter Real cs1(unit="Btu/lb.F")=0.244           "Humid heat";//taken from Fig19.2 Pg621
parameter Real Ty(unit="F")=70                      "Temperature of gas";
parameter Real Tw(unit="F")=60                      "Wet bulb Temperature";
parameter Real TW1(unit="F")=105                    "Inlet water Temperature";
parameter Real TW2(unit="F")=85                     "Outlet water Temperature";

//===================
// Variable Section
Real Hb1(unit="Btu/lb")       "Enthalpy";
Real Ha1(unit="Btu/lb")       "Enthalpy";
Real deltaT(unit="F")         "Temperatre difference";

//==================
//Equation  Section 
equation
Hb1=cs1*(70-32)+(1075*hb1);
Gx*1*20=Gy*(Ha1-Hb1);
deltaT=75-60;

end Ex19_3_2;

end Ex19_3;
