//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education, 2014

//Chapter 2: Fluid Statics and its Applications
//Example  : 2.1 Pg 36
//Title: Manometers
//================================================================================================

model Ex2_1

//===================
// Parameter Section
parameter Real Pa(unit = "Pa")= 0.14*10^5 "Gauge pressure at the upstream.";
parameter Real rhoa(unit = "kg/m3")=13590 "Density of liquid A (Mercury)";
parameter Real rhob(unit = "kg/m3")=1260  "Density of liquid B  (Brine)";
parameter Real g(unit = "m/s2")=9.80556   "Acceleration due to gravity";
parameter Real Zb(unit = "mm")=250        "Height of the liquid B";


//===================
// Variable Section 
Real Rm(unit="m") "Rm is the manometer reading.";
Real Pb(unit="Pa")"Pa is Pascal. Pb is pressure.";


//==================
// Equation  Section 
equation
Pb= (-Zb*0.001)*rhoa*g; //Zb is multiplies by 0.001 to convert it to metres.
(Pa-Pb) =g*Rm*(rhoa-rhob);

end Ex2_1;
//================================================================================================
