//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 21: Distillation.
//Example  : 21.4 Pg 693
//Title: Continuous distillation with reflux. 
//================================================================================================

model Ex21_4
//===================
// Parameter Section
parameter Real F(unit="nil")=1             "Feed rate";
parameter Real Lbar(unit="nil")=1          "Liquid rate";
parameter Real Vbar(unit="nil")=0.2        "Gas rate";
parameter Real xa(unit="nil")=0.02         "Mole fraction in liquid";
parameter Real xb(unit="nil")=0.0001       "Mole fraction in liquid";
parameter Real yb(unit="nil")=0            "Mole fraction in vapour";
parameter Real m(unit="nil")=9             "Serial number of plate in stripping column";

//===================
// Variable Section
Real ya(unit="nil")       "Mole fraction";
Real yastar(unit="nil")       "Mole fraction in equilibirium";
Real ybstar(unit="nil")       "Mole fraction in equilibirium";
Real N(unit="nil")            "Number of ideal plates";

//==================
//Equation  Section 
equation
yastar=m*xa;
ybstar=m*xb;
Vbar*(ya-0)=(Lbar*(xa-xb));
N=log((ya-yastar)/(yb-ybstar))/log((ybstar-yastar)/(yb-ya));

end Ex21_4;
