//Warren L. McCabe, Julian C. Smith, Peter Harriot, Unit Operations Of Chemical Engineering, 7th Edn.,McGraw Hill Higher Education,2014

//Chapter 21: Distillation.
//Example  : 21.7 Pg 717
//Title: Plate efficiencies. 
//================================================================================================

model Ex21_7
//===================
// Parameter Section
parameter Real x(unit="nil")=15       "Variable used to represent L/V ratio";
parameter Real etam(unit="nil")=0.40  "Murphee plate efficiency";

//===================
// Variable Section
Real y(unit="nil")          "Variable to represent mV/L";
Real eta(unit="nil")        "Overall efficiency";

//==================
//Equation  Section 
equation
y=(120/15); //An equilibirium relation is given. ystar=120*x
eta=log(1+etam*(y-1))/log(y);


end Ex21_7;
